/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;

import javax.management.ObjectName;
import javax.management.AttributeList;


import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.config.WebServiceEndpointConfigKeys;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.util.misc.TypeCast;


final class WebServiceEndpointConfigFactory  extends ConfigFactory
{
		public
	WebServiceEndpointConfigFactory(
		final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}

    	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		    WebServiceEndpointConfigKeys.MONITORING_LEVEL_KEY,
		    WebServiceEndpointConfigKeys.JBI_ENABLED_KEY,
		    WebServiceEndpointConfigKeys.MAX_HISTORY_SIZE_KEY
	);

                
        protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}

		protected Map<String,String>
	getParamNameOverrides()
	{
        Map<String,String> m = new HashMap<String,String>();
        m.put(WebServiceEndpointConfigKeys.MONITORING_LEVEL_KEY, "Monitoring");
        m.put(WebServiceEndpointConfigKeys.JBI_ENABLED_KEY, "JbiEnabled");

		return( m );
	}

  /**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs )
	{
        final ObjectName oldObjectName = (ObjectName)
        getCallbacks().getDelegate().invoke(
            CREATE_WEB_SERVICE_ENDPOINT, new Object[] { translatedAttrs }, 
            CREATE_WEB_SERVICE_ENDPOINT_SIG );
		
		return oldObjectName;

	}

		public ObjectName
	create(
        final String    name,
        final Map<String,String> optional  )
	{
        final Map<String,String> params = initParams(name, null, optional);

        trace( "params as processed: " + stringify( params ) );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
    }


		public void
	internalRemove( final ObjectName wseConfigObjectName )
	{
         final String	name	= Util.getName( wseConfigObjectName );

	    getCallbacks().getDelegate().invoke( REMOVE_WEB_SERVICE_ENDPOINT, new
        Object[] { name }, REMOVE_WEB_SERVICE_ENDPOINT_SIG );
		getCallbacks().sendConfigRemovedNotification( wseConfigObjectName );
	}


        private static final String CREATE_WEB_SERVICE_ENDPOINT  =
        "createWebServiceEndpoint";
        private static final String[] CREATE_WEB_SERVICE_ENDPOINT_SIG  = new String[] { AttributeList.class.getName() };
          private static final String REMOVE_WEB_SERVICE_ENDPOINT  =
            "removeWebServiceEndpointByName";
        private static final String[] REMOVE_WEB_SERVICE_ENDPOINT_SIG  = 
            new String[] { String.class.getName() };


}





