/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.ext.logging;

import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;

import javax.management.AttributeList;
import javax.management.NotificationEmitter;


/**
    Interface of class com.sun.enterprise.server.logging.LogMBean.
 */
interface LogMBeanIntf extends NotificationEmitter
{
    public List getLoggerNames();

    public List   getLoggerNamesUnder( String loggerName );
    public String getLogLevel( String loggerName );
    public void   setLogLevel( String loggerName, String level );
    public void   setLogLevelForModule( String module, String level );

    public AttributeList getLogRecordsUsingQuery( 
        String  logFilename,
        Long    fromRecord,
        Boolean next,
        Boolean forward,
        Integer requestedCount,
        Date    fromDate,
        Date    toDate,
        String  logLevel,
        Boolean onlyLevel,
        List    listOfModules,
        Properties nameValueMap) ;
    
    public String[] getArchivedLogfiles();
    public void rotateNow();
    public void rotateAccessLog();

    public String getLogFilesDirectory();
    
    public ArrayList	getDiagnosticCausesForMessageId( String messageID );
    public ArrayList	getDiagnosticChecksForMessageId( String messageID );
    public String       getDiagnosticURIForMessageId( String messageID );
    
    /**
     * @return a list of Map objects. Each map object contains
     * the tuple [TimeStamp, SevereCount, WarningCount].
     */   
    public List<Map<String,Object>> getErrorInformation();
    
    /**
     * @return a list of Map objects. Each map object contains
     * the tuple [ModuleId, SevereCount|WarningCount].
     */    
    public Map<String,Integer> getErrorDistribution( long timeStamp, Level level);
    
    public void setKeepErrorStatisticsForIntervals(int numberOfIntervals);
    public int getKeepErrorStatisticsForIntervals();

    public void setErrorStatisticsIntervalDuration(long minutes);
    public long getErrorStatisticsIntervalDuration(); 

};