/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.monitor;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.Collections;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.monitor.CallFlowMonitor;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.Switch;
/**
    @see CallFlowMonitor
*/
public final class CallFlowMonitorImpl extends MonitoringImplBase
	//implements CallFlowMonitor
{
    private boolean             mCallFlowEnabled;
    
	public CallFlowMonitorImpl()
	{
	    super( XTypes.CALL_FLOW_MONITOR );
	    mCallFlowEnabled    = false;        
            
	}
		      
    public boolean getEnabled() {
        return mCallFlowEnabled;
    }

    public void setEnabled(final boolean enabled) {
        final Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();
        callflowAgent.setEnable(enabled);
        mCallFlowEnabled = callflowAgent.isEnabled ();
    }
    

    public void clearData (){
        final Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();        
        callflowAgent.clearData();
    }
    
    public boolean deleteRequestIDs (String[] requestId){
        final Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();        
        return callflowAgent.deleteRequestIds(requestId);
    }
    public List<Map<String, String>> queryRequestInformation (){
        Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();        
        return callflowAgent.getRequestInformation ();
    }

    public List<Map<String, String>> queryCallStackForRequest(String rid){
        Agent callflowAgent = Switch.getSwitch().getCallFlowAgent(); 
        return callflowAgent.getCallStackForRequest (rid);
    }
    

    public Map<String, String> queryPieInformation (String rid){
        Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();
        return callflowAgent.getPieInformation(rid);        
    }

    public String getCallerIPFilter (){
        Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();
        return callflowAgent.getCallerIPFilter();
    }
    
    public void setCallerIPFilter(String filter) {
        Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();
        callflowAgent.setCallerIPFilter(filter);        
    }
    public String getCallerPrincipalFilter() {
        Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();
        return callflowAgent.getCallerPrincipalFilter();
    }
    
    public void setCallerPrincipalFilter(String filter) {
        Agent callflowAgent = Switch.getSwitch().getCallFlowAgent();
        callflowAgent.setCallerPrincipalFilter(filter);
    }
    
    public String[] queryRequestTypeKeys (){
        String[] requestType = 
            {
            CallFlowMonitor.REMOTE_ASYNC_MESSAGE, 
            CallFlowMonitor.REMOTE_EJB,
            CallFlowMonitor.REMOTE_WEB,
            CallFlowMonitor.REMOTE_WEB_SERVICE,
            CallFlowMonitor.TIMER_EJB
            };
            
            return requestType;
    }
    public String[] queryComponentTypeKeys (){
        String[] componentType = 
        {
            CallFlowMonitor.BEAN_MANAGED_PERSISTENCE,
            CallFlowMonitor.CONTAINER_MANAGED_PERSISTENCE,
            CallFlowMonitor.MESSAGE_DRIVEN_BEAN,
            CallFlowMonitor.SERVLET,
            CallFlowMonitor.SERVLET_FILTER,
            CallFlowMonitor.STATEFUL_SESSION_BEAN,
            CallFlowMonitor.STATELESS_SESSION_BEAN
        };
        return componentType;
    }
    public String[] queryContainerTypeOrApplicationTypeKeys (){
        String[] containerType = 
        {
            CallFlowMonitor.WEB_CONTAINER,
            CallFlowMonitor.EJB_CONTAINER,
            CallFlowMonitor.ORB,
            CallFlowMonitor.WEB_APPLICATION,
            CallFlowMonitor.EJB_APPLICATION,     
            CallFlowMonitor.OTHER        
        };
        return containerType;
    }
}

