/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.offline;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Collections;

import javax.management.ObjectName;


/**
 */
public final class OfflineDottedNamesRegistry
{
	/**
	    Maps from dotted name prefxi to ObjectName
	 */
	private Map<String,ObjectName>  mPrefixToObjectName;
	
	/**
	    Maps from ObjectName to all dotted name prefixes.
	 */
	private Map<ObjectName,String>  mObjectNameToPrefix;
	
	
	/**
	    The legal attribute names
	 */
	private Map<ObjectName,Set<String>>  mLegalAttributes;
	
		public
	OfflineDottedNamesRegistry()
	{
	    mPrefixToObjectName   = new HashMap<String,ObjectName>();
	    mObjectNameToPrefix   = new HashMap<ObjectName,String>();
	    mLegalAttributes      = new HashMap<ObjectName,Set<String>>();
	}
	
	/**
	    Add a mapping from an ObjectName to its dotted name prefixes.
	    @param objectName   the ObjectName in question
	    @param prefix     one or more prefixes associated with this ObjectName
	    @param legalAttributes  the legal attributes, as found in the MBeanInfo of the ObjectName
	 */
	    public synchronized void
	addMapping(
	    final ObjectName   objectName,
	    final String       prefix,
	    final Set<String>  legalAttributes )
	{
	    if ( objectName == null || prefix == null )
	    {
	        throw new IllegalArgumentException( "null" );
	    }
	    
	    if ( mObjectNameToPrefix.containsKey( objectName ) )
	    {
	        throw new IllegalArgumentException( "Already registered: " + objectName );
	    }
	    
	    mObjectNameToPrefix.put( objectName, prefix );
	    mPrefixToObjectName.put( prefix, objectName );
	    mLegalAttributes.put( objectName, Collections.unmodifiableSet( legalAttributes ) );
	}
	
	    public synchronized void
	removeMapping( final ObjectName objectName )
	{
	    final String  prefix    = mObjectNameToPrefix.get( objectName );
	    if ( prefix != null )
	    {
	        mObjectNameToPrefix.remove( objectName );
	        mLegalAttributes.remove( objectName );
            mPrefixToObjectName.remove( prefix );
	    }
	}
	
	    public String
	getPrefix( final ObjectName objectName )
	{
	    return mObjectNameToPrefix.get( objectName );
	}
	
	    public ObjectName
	getObjectName( final String prefix )
	{
	    return mPrefixToObjectName.get( prefix );
	}
	
	    public Set<String>
	getLegalAttributes( final ObjectName objectName )
	{
	    return mLegalAttributes.get( objectName );
	}
	
	    public Set<ObjectName>
	getObjectNames()
	{
	    final Set<ObjectName>   result  = new HashSet<ObjectName>();
	    
	    result.addAll( mObjectNameToPrefix.keySet() );
	    return result;
	}
	
	    public Set<String>
	getPrefixes()
	{
	    final Set<String>   result  = new HashSet<String>();
	    
	    result.addAll( mObjectNameToPrefix.values() );
	    return result;
	}
}
































