/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import java.util.Properties;

import javax.management.ObjectName;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.MapUtil;


import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.LifecycleEvent;
import static com.sun.appserv.server.LifecycleEvent.*;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.ServerLifecycleException;


/**
 */
public final class AMXLifecycleModule implements LifecycleListener
{
    private final String    NEWLINE;
    
		public
	AMXLifecycleModule()
	{
	    NEWLINE = System.getProperty( "line.separator" );
	}
	
	    private void
	init(
	    final LifecycleEventContext context,
	    final Properties props )
	{
	    context.log( "AMXLifecycleModule: init" );
	}
	
	    private void
	startup(
	    final LifecycleEventContext context,
	    final Properties props )
	{
	    context.log( "AMXLifecycleModule: startup" );
	}
	
	    private void
	ready(
	    final LifecycleEventContext context,
	    final Properties props )
	{
	    context.log( "AMXLifecycleModule: ready" );
	}
	
	    private void
	shutdown(
	    final LifecycleEventContext context,
	    final Properties props )
	{
	    context.log( "AMXLifecycleModule: shutdown" );
	}
	
	    private void
	terminate(
	    final LifecycleEventContext context,
	    final Properties props )
	{
	    context.log( "AMXLifecycleModule: terminate" );
	}
	
	    private void
	dumpInfo(
	    final int   eventType,
	    final LifecycleEventContext context,
	    final Properties props )
	{
	    final String msg    = "AMXLifecycleModule: " + eventType + NEWLINE +
	        "InstallRoot: " + context.getInstallRoot() + NEWLINE +
	        "InstanceName: " + context.getInstanceName() + NEWLINE +
	        "CmdLineArgs: " + StringUtil.toString( " ", (Object[])context.getCmdLineArgs() ) + NEWLINE +
	        "Properties: " + NEWLINE +
	        MapUtil.toString( props, NEWLINE ) + NEWLINE;
	    
	    context.log( msg );
	        
	}
	
	
        public void
    handleEvent(LifecycleEvent event)
        throws ServerLifecycleException
    {
        final int  type  = event.getEventType();
        
        final Properties    props   = (Properties)event.getData();
        final LifecycleEventContext context = event.getLifecycleEventContext();
        
        dumpInfo( type, context, props );
        
        if ( type == INIT_EVENT )
        {
            init( context, props );
        }
        else if ( type == STARTUP_EVENT )
        {
            startup( context, props );
        }
        else if ( type == READY_EVENT )
        {
            ready( context, props );
        }
        else if ( type == SHUTDOWN_EVENT )
        {
            shutdown( context, props );
        }
        else if ( type == TERMINATION_EVENT )
        {
            terminate( context, props );
        }
        else
        {
            throw new IllegalArgumentException( "eventType: " + type );
        }
    }
}








