/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/AuditModuleConfigTest.java,v 1.5 2006/03/09 20:30:52 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:52 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.AuditModuleConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;


/**
 */
public final class AuditModuleConfigTest extends ConfigMgrTestBase
{
	static final String CLASSNAME	= "com.sun.enterprise.security.Audit";
	
		public
	AuditModuleConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getConfigConfig().getSecurityServiceConfig() );
	    }
	}
	
	
        public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "AuditModuleConfig" );
    }
    
    
        public static AuditModuleConfig
	ensureDefaultInstance( final SecurityServiceConfig securityServiceConfig )
	{
	    AuditModuleConfig   result  =
	        securityServiceConfig.getAuditModuleConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( securityServiceConfig,
	            getDefaultInstanceName(), CLASSNAME, false, null );
	    }
	    
	    return result;
	}
	
	    public static AuditModuleConfig
	createInstance(
	    final SecurityServiceConfig securityServiceConfig,
	    final String    name,
	    final String    classname,
	    final boolean   enabled,
	    final Map<String,String> optional )
	{
	    return  securityServiceConfig.createAuditModuleConfig(
	            name, CLASSNAME, enabled, null );
	}
	
	
	
		protected Container
	getProgenyContainer()
	{
		return getConfigConfig().getSecurityServiceConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.AUDIT_MODULE_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getConfigConfig().getSecurityServiceConfig().removeAuditModuleConfig( name );
	}
	
		protected final AMXConfig
	createProgeny( final String name, final Map<String,String> options )
	{
	    return getConfigConfig().getSecurityServiceConfig().createAuditModuleConfig(name, CLASSNAME, false, options);
	}
}


