/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConnectorServiceConfig;

import com.sun.appserv.management.util.misc.ExceptionUtil;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class ConnectorServiceConfigTest extends AMXTestBase
{
    public ConnectorServiceConfigTest()
    {
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
            ensureDefaultInstance( getConfigConfig() );
        }
    }
    
         public static ConnectorServiceConfig
	ensureDefaultInstance( final ConfigConfig configConfig )
	{
	    return configConfig.createConnectorServiceConfig();
	}
	
	    public synchronized void
	testCreateRemove()
	{
	    if ( checkNotOffline( "testCreateRemove" ) )
	    {
    	    final ConfigConfig  configConfig    = getConfigConfig();
    	    
    	    // remove first, in case it's there
    	    configConfig.removeConnectorServiceConfig();
    	    
    	    // create and remove
    	    configConfig.createConnectorServiceConfig();
    	    configConfig.removeConnectorServiceConfig();
    	    
    	    // leave it there
    	    ensureDefaultInstance( configConfig );
	    }
	}
	
	    public synchronized void
	testGetters()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getConfigConfig() );
    	    
    	    final ConnectorServiceConfig    cs  = getConfigConfig().getConnectorServiceConfig();
    	    
    	    final String    value   = cs.getShutdownTimeoutInSeconds();
    	    assert( value != null );
    	    
    	    try
    	    {
    	        final String    newValue    = "" + (Integer.parseInt( value ) + 1);
        	    cs.setShutdownTimeoutInSeconds( newValue );
        	    final String after  = cs.getShutdownTimeoutInSeconds();
        	    assert( after.equals( newValue ) );
        	    
        	    cs.setShutdownTimeoutInSeconds( "30" );
        	    cs.setShutdownTimeoutInSeconds( newValue );
    	    }
    	    catch( Exception e )
    	    {
    	        warning( getRootCauseStackTrace( e ) );
    	        
    	        failure( "ConnectorServiceConfig.setShutdownTimeoutInSeconds FAILED " +
    	            "(bug #6307916 in com.sun.appserv:type=connector-service MBean)" );
    	    }
	    }
	}
}










