/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.logging.Level;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DiagnosticServiceConfig;

import com.sun.enterprise.management.AMXTestBase;

/**
 */
public final class DiagnosticServiceConfigTest extends AMXTestBase
{
    public DiagnosticServiceConfigTest()
    {
    }
    
        public  void
    testCreateRemove()
    {
        final ConfigConfig  config = getConfigConfig();
        
        // set defaults
        boolean   computeChecksum   = true;
        boolean   captureInstallLog = true;
        boolean   captureSystemInfo = true;
        boolean   captureHADBInfo   = true;
        boolean   captureAppDD      = true;
        boolean   verifyConfig      = true;
        String    minLogLevel       = Level.INFO.toString();
        String    maxLongEntries    = "10000";
        
        DiagnosticServiceConfig ds  = config.getDiagnosticServiceConfig();
        if ( ds != null )
        {
            // remember current settings
            computeChecksum   = ds.getComputeChecksum();
            captureInstallLog = ds.getCaptureInstallLog();
            captureSystemInfo = ds.getCaptureSystemInfo();
            captureHADBInfo   = ds.getCaptureHADBInfo();
            captureAppDD      = ds.getCaptureAppDD();
            verifyConfig      = ds.getVerifyConfig();
            minLogLevel       = ds.getMinLogLevel();
            maxLongEntries    = ds.getMaxLogEntries();
            
            config.removeDiagnosticServiceConfig();
            ds  = null;
        }
        
        ds  = config.createDiagnosticServiceConfig();
        config.removeDiagnosticServiceConfig(); ds = null;
        
        // re-create it so one stays around
        ds  = config.createDiagnosticServiceConfig();
        ds.setComputeChecksum( computeChecksum );
        ds.setCaptureInstallLog( captureInstallLog);
        ds.setCaptureSystemInfo( captureSystemInfo );
        ds.setCaptureHADBInfo( captureHADBInfo );
        ds.setCaptureAppDD( captureAppDD );
        ds.setVerifyConfig( verifyConfig );
        ds.setMinLogLevel( minLogLevel );
        ds.setMaxLogEntries( maxLongEntries );
    }
 
}


