/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/ModuleLogLevelsConfigTest.java,v 1.5 2005/12/25 03:41:39 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:41:39 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;

import javax.management.ObjectName;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

import com.sun.appserv.management.config.ModuleLogLevelsConfig;
import com.sun.appserv.management.config.LogLevelValues;


/**
 */
public final class ModuleLogLevelsConfigTest extends AMXTestBase
{
		public
	ModuleLogLevelsConfigTest ()
	{
	}
	
		protected ModuleLogLevelsConfig
	getModuleLogLevelsConfig()
	{
		return getConfigConfig().getLogServiceConfig().getModuleLogLevelsConfig();
	}
	
		public void
	testGetAll()
	{
		final ModuleLogLevelsConfig	config	= getModuleLogLevelsConfig();
		
		final Map<String,String>	all	= config.getAllLevels();
		assert( all.size() == 24 );
	}
	
		public void
	testChangeAll()
	{
		final ModuleLogLevelsConfig	config	= getModuleLogLevelsConfig();
		
		config.changeAll( LogLevelValues.FINE );
		// verify that they were all changed
		 Map<String,String>	all	= config.getAllLevels();
		for( final String value : all.values() )
		{
		    assert( value.equals( LogLevelValues.FINE ) );
		}
		
		config.changeAll( LogLevelValues.INFO );
		// verify that they were all changed
		all	= config.getAllLevels();
		for( final String value : all.values() )
		{
		    assert( value.equals( LogLevelValues.INFO ) );
		}
	}
}


