/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.ext.logging;

import java.util.List;
import java.util.Set;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.helper.LoggingHelper;

import com.sun.appserv.management.ext.logging.Logging;
import static com.sun.appserv.management.ext.logging.Logging.*;
import com.sun.appserv.management.ext.logging.LogModuleNames;
import com.sun.appserv.management.ext.logging.LogRecordFields;
import com.sun.appserv.management.ext.logging.LogQueryResult;
import com.sun.appserv.management.ext.logging.LogQueryResultImpl;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
    Test the LoggingHelper.
 */
public final class LoggingHelperTest extends AMXTestBase
{
		public
	LoggingHelperTest( )
	{
	}
	    
	    final Set<Logging>
	getAllLogging()
	{
	    return getQueryMgr().queryJ2EETypeSet( XTypes.LOGGING );
	}
	
	    public LoggingHelper
	createHelper( final Logging logging )
	{
	    return new LoggingHelper( logging );
	}
	
	
	    private void
	validateResult( final LogQueryResult result )
	{
	    assert( result != null );
	    assert( result.getFieldNames() != null );
	    assert( result.getEntries() != null );
	}

	    public void
	testQueryServerLogSingle()
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
    	    final LogQueryResult    result  = 
    	        helper.queryServerLog( LOWEST_SUPPORTED_QUERY_LEVEL, "EJB" );
    	    validateResult( result );
	    }
	}
	
	
	
	    public void
	testQueryServerLogLevelAndModules()
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
	        
	        final LogQueryResult    result  = 
	            helper.queryServerLog( LOWEST_SUPPORTED_QUERY_LEVEL,
	            LogModuleNames.ALL_NAMES );
	        validateResult( result );
	    }
	}
	
	
	    public void
	testQueryServerLogLevel()
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
	        
    	    final LogQueryResult    result  = 
    	        helper.queryServerLog( LOWEST_SUPPORTED_QUERY_LEVEL );
    	    validateResult( result );
    	}
	}
	
	
	    public void
	testQueryAllCurrent()
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
	        
    	    final LogQueryResult    result  =  helper.queryAllCurrent();
    	    validateResult( result );
    	}
	}
	
	
	private static final int    HOUR_MILLIS = 60 * 60 * 1000;
	    public void
	testQueryServerLogRecent()
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
	        
    	    final LogQueryResult    result  = 
    	        helper.queryServerLogRecent( HOUR_MILLIS );
    	    validateResult( result );
    	}
	}
	
	
	    public void
	testQueryServerLogRecentWithModules( )
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
	        
    	    final LogQueryResult    result  = 
    	        helper.queryServerLogRecent(
    	            HOUR_MILLIS, LogModuleNames.ALL_NAMES );
    	    validateResult( result );
    	 }
	}
	
	
	    public void
	testQueryAllInFile( )
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
	        
    	    final String[]  names   = logging.getLogFileNames( SERVER_KEY );
    	    for( final String name : names )
    	    {
        	    final LogQueryResult    result  = helper.queryAllInFile( name );
        	    validateResult( result );
    	    }
	    }
	}
	
	  public void
	testQueryAll( )
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        final LoggingHelper helper  = createHelper( logging );
	        
    	    final LogQueryResult[]    results  = helper.queryAll();
    	    for( final LogQueryResult result : results )
    	    {
    	        validateResult( result );
    	    }
	    }
	}

	
}





















