/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/monitor/JMXMonitorMgrTest.java,v 1.4 2005/12/25 03:41:55 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:41:55 $
 */
package com.sun.enterprise.management.monitor;

import java.io.IOException;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.monitor.JMXMonitorMgr;
import com.sun.appserv.management.monitor.AMXStringMonitor;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class JMXMonitorMgrTest extends AMXTestBase
{
		public
	JMXMonitorMgrTest( )
	{
	}
	
		public JMXMonitorMgr
	getMgr()
	{
		return( getDomainRoot().getJMXMonitorMgr() );
	}
	
		public void
	testGetMgr()
	{
		final JMXMonitorMgr	mgr	= getMgr();
		assert( mgr != null );
	}
	
		public void
	testCreateRemoveStringMonitor()
		throws IOException
	{
		final JMXMonitorMgr	mgr	= getMgr();
		
		final AMXStringMonitor	mon	= mgr.createStringMonitor( getClass().getName() + "Test" );
		final ObjectName	objectName	= Util.getObjectName( mon );
		
		mon.setObservedAttribute( "Group" );
		final ObjectName	observee	= Util.getObjectName( mgr );
		assert( observee != null );
		mon.addObservedObject( observee );
		assert mon.containsObservedObject( observee );
		mon.removeObservedObject( observee );
		
		assert( getConnection().isRegistered( objectName ) );
		mgr.remove( mon.getName() );
		assert( ! getConnection().isRegistered( objectName ) );
	}
}


