/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameResolverForAliases.java,v 1.3 2005/12/25 03:42:03 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:03 $
 */


package com.sun.enterprise.admin.dottedname;

import java.util.Set;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;

import com.sun.enterprise.admin.util.ArrayConversion;


/*
	This implementation understands that some names are aliased.  For example,
	"server.xxx" is aliased to "config.xxx".
 */
 
public class DottedNameResolverForAliases implements DottedNameResolver
{
	final DottedNameQuery				mQuery;
	final DottedNameServerInfo			mServerInfo;
	
		public
	DottedNameResolverForAliases(
		final DottedNameQuery		query,
		final DottedNameServerInfo	serverInfo )
	{
		mQuery			= query;
		mServerInfo		= serverInfo;
	}

	
	/*
		Change the dotted name into its "true" name.  For example "server-name.xxx" translates
		to "config-name.xxx".
	 */
		protected String
	getUnaliasedName( final String dottedNameString )
	{
		final DottedName	dn	= DottedNameFactory.getInstance().get( dottedNameString );
		DottedName			actualDN	= dn;
		
		if ( ! DottedName.isWildcardName( dottedNameString ) )
		{
			try
			{
				final String	actualScope	=
					DottedNameAliasSupport.resolveScope( mServerInfo, dn );
				
				if ( ! actualScope.equals( dn.getScope() ) )
				{
					actualDN	= DottedNameFactory.getInstance().get(
						DottedName.toString( dn.getDomain(), actualScope, dn.getParts() ) );
				}
			}
			catch( Exception e )
			{
				DottedNameLogger.logException( e );
			}
		}
		
		return( actualDN.toString() );
	}
	
	/*
	static java.util.logging.Logger		sLogger	= null;
		static void
	dm( Object o )
	{
		if (sLogger == null )
		{
        	sLogger	= java.util.logging.Logger.getLogger( "DottedNameGetSetMBeanImplLogger" );
        	sLogger.setLevel( java.util.logging.Level.INFO );
        }
        
        sLogger.info( o.toString() );
	}
	*/
	
		public ObjectName
	resolveDottedName( final String dottedName )
	{
		final String		unaliasedName	= getUnaliasedName( dottedName );
		
		final ObjectName	result	= mQuery.dottedNameToObjectName( unaliasedName );
		
		return( result );
	}
}




