/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import javax.management.ObjectName;
import java.util.Set;
import java.util.Map;
import com.sun.enterprise.admin.wsmgmt.msg.MessageTraceMgr;
import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.enterprise.admin.wsmgmt.stats.spi.StatsProviderManager;
import com.sun.enterprise.admin.wsmgmt.stats.spi.WebServiceEndpointStatsProvider;

/**
 * WebServiceEndpoint type rutime MBean for Servlet web service endpoints.
 * This MBean provides functionality required for content visualization. 
 */ 
public class ServletWebServiceEndpointMdl extends WebServiceEndpointMdl {
    
    /**
     * Public constructor.
     *
     * @param name          Name of the web service endpoint
     * @param moduleName    Name of the module (which this web service belongs)
     * @param regName       registration name of the application or module
     * @param isVirtual     true, if the module is stand alone, false otherwise
     * @param isEjb         If this Web service endpoint is implemented as EJB
     *                      or Servlet
     */
    public ServletWebServiceEndpointMdl(String name,String mName,String regName,
           boolean isVirtual, boolean isejb) {

        super(name,mName, regName, isVirtual, isejb);
    }

    /**
     * Public constructor.
     *
     * @param name          Name of the web service endpoint
     * @param moduleName    Name of the module (which this web service belongs)
     * @param regName       registration name of the application or module
     * @param serverName    Name of the server instance
     * @param isVirtual     true, if the module is stand alone, false otherwise
     * @param isEjb         If this Web service endpoint is implemented as EJB
     *                      or Servlet
     */
    public ServletWebServiceEndpointMdl(String name, String moduleName, 
            String regName, String serverName,boolean isVirtual,boolean isejb) {

        super(name,moduleName, regName, serverName, isVirtual,isejb);
    }

    /**
     * The MBean name of the J2EEManagedObject as specified in
     * runtime-mbeans-descriptors.xml. This value is used in registering the 
     * MBean.
     * 
     * @return String MBeanName value of this Managed Object
     */
    public String getMBeanName() {
             return WEB_MBEAN;
    }
}
