/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MethodStartAccessObjectImplTest.java
 * JUnit based test
 *
 * Created on July 14, 2005, 1:59 PM
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.sql.DriverManager;
import java.sql.PreparedStatement;
import junit.framework.*;
import java.sql.Connection;
import com.sun.enterprise.admin.monitor.callflow.TableInfo;
import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;

/**
 *
 * @author Harpreet Singh
 */
public class MethodStartAccessObjectImplTest extends TestCase {
    Connection con = null;
    TableAccessObject ms = null;    
    PreparedStatement pstmt = null;
    MethodStartTO[] methodStart = new MethodStartTO[10];    
        
    public MethodStartAccessObjectImplTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    try{
            // TODO code application logic here
            String url="jdbc:derby://localhost:1527/sun-callflow;retrieveMessagesFromServerOnGetMessage=true;create=true;";            
            Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
            con = DriverManager.getConnection(url, "APP", "APP");         
            // drop request start table
            ms = MethodStartAccessObjectImpl.getInstance();            
        } catch (Exception e){
            e.printStackTrace();
        }        
                
    }

    protected void tearDown() throws Exception {
        try{
            con.close();
        } finally{
            con = null;
        }
    }
    
    /**
     * Test of createTable method, of class com.sun.enterprise.admin.monitor.callflow.MethodStartAccessObjectImpl.
     */
    public void testCreateTable() {
       System.out.println("Method Start : testCreateTable");
        boolean result = false;
        try{
            result = ms.createTable(con);
            System.out.println("Method Start Create Table returned = "+ result);
        }catch (Exception e){
            e.printStackTrace();
        }
        assertTrue(result);           
    }
   public void testInsert (){
        System.out.println(" testStoreMethodStart");
        try{
            String insertSQL = ms.getInsertSQL();
            System.out.println (" Insert SQL :"+ insertSQL);            
            pstmt = con.prepareStatement(insertSQL);
            
            
            for (int i = 0; i < methodStart.length; i++) {
                methodStart[i] = new MethodStartTO();
                methodStart[i].requestId = "RequestID_"+i;
                methodStart[i].timeStamp = System.nanoTime();
                methodStart[i].componentType = ComponentType.SERVLET;
                methodStart[i].componentName = "Component_Name_"+i;
                methodStart[i].appName = "APP_NAME";
                methodStart[i].methodName = "Method_Name_" +i;
                methodStart[i].moduleName = "Module_Name_" +i;
                methodStart[i].transactionId = "Transaction_Id_"+i;
                methodStart[i].threadId = "Thread_Id_"+i;
                methodStart[i].securityId = "watchman_"+i;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        boolean result = ms.insert (pstmt, methodStart);
        System.out.println("testStoreMethodStart returned = "+result);
        assertTrue (result);
    }    
    /**
     * Test of dropTable method, of class com.sun.enterprise.admin.monitor.callflow.MethodStartAccessObjectImpl.
     */
    public void testDropTable() {
        System.out.println("Method Start testDropTable");
        boolean result = ms.dropTable(con);
        System.out.println("Method Start Drop Table returned = "+result);
        assertTrue(result);
    }

    public static void main(java.lang.String[] argList) {

//        junit.textui.TestRunner.run(suite());
    }
    
}
