/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.config.impl;

import com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule;

/**
 * This represents transformation rule for a web service end point. 
 */
public class TransformationRuleImpl implements TransformationRule {

    public TransformationRuleImpl(String n, boolean enable, String apply,
                    String loc) {
        name = n;
        enabled = enable;
        applyTo = apply;
        fileLoc = loc;
    }

    public TransformationRuleImpl(
            com.sun.enterprise.config.serverbeans.TransformationRule tRule) {

        name = tRule.getName();
        enabled = tRule.isEnabled();
        applyTo = tRule.getApplyTo();
        fileLoc = tRule.getRuleFileLocation();
    }

    /**
     * Returns the name of the transformation rule
     *
     * @return the name of the transformation rule
     */
    public String getName() {
        return name;
    }

    /**
     * Returns true, if this transformation rule is enabled
     *
     * @return true, if this transformation rule is enabled
     */
    public boolean getEnabled() {
        return enabled;
    }
    
    /**
     * Returns the value of "Apply-to" attribute
     *
     * @return the value of "Apply-to" attribute
     */
    public String getApplyTo() {
        return applyTo;
    }

    /**
     * Returns the location of rule file 
     *
     * @return the location of rule file
     */
    public String getRuleFileLocation() {
        return fileLoc;
    }


    // PRIVATE VARIABLES
    String name = null, applyTo = null, fileLoc = null;
    boolean enabled = false;
}
