// Copyright (c) 2004-2005 Sun Microsystems Inc., All Rights Reserved.

/*
 * SOAPWrapper.java
 *
 * SUN PROPRIETARY/CONFIDENTIAL.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.xml.soap.SOAPMessage;


/**
 * This object provides a wrapper for SOAP Messages and also contains status information.
 * The wrapper allows clients to attach properties to it.
 *
 * @author Sun Microsystems, Inc.
 */
public class SOAPWrapper
{
    /**
     * A place holder to hold additional name-value pairs.
     */
    private Map mMap;

    /**
     * Contains handle to the soap message.
     */
    private SOAPMessage mMessage;

    /**
     * Request Status.
     */
    private int mStatus;

    /**
     * Internal handle to the service URL.
     */
    private String mServiceURL;

    /**
     * Creates a new instance of SOAPWrapper.
     *
     * @param soapMessage - soap message
     */
    public SOAPWrapper(SOAPMessage soapMessage)
    {
        mMessage = soapMessage;
        mMap = new HashMap();
    }

    /**
     * Sets status.
     *
     * @param status request status
     */
    public void setStatus(int status)
    {
        mStatus = status;
    }

    /**
     * Gets status.
     *
     * @return status information
     */
    public int getStatus()
    {
        return mStatus;
    }

    /**
     * Gets Service URL.
     *
     * @return service URL
     */
    public String getServiceURL()
    {
        return mServiceURL;
    }

    /**
     * Sets Service URL.
     *
     * @param serviceURL service url.
     */
    public void setServiceURL(String serviceURL)
    {
        mServiceURL = serviceURL;
    }

    /**
     * Gets the soap message.
     *
     * @return soap message instance
     */
    public SOAPMessage getMessage()
    {
        return mMessage;
    }

    /**
     * Sets a property to the SOAP Wrapper.
     *
     * @param propertyName property name
     * @param value property value
     */
    public void setValue(String propertyName, Object value)
    {
        mMap.put(propertyName, value);
    }

    /**
     * Sets a property to the SOAP Wrapper.
     *
     * @param propertyName property name
     *
     * @return property value
     */
    public Object getValue(String propertyName)
    {
        return mMap.get(propertyName);
    }

    /**
     * Get the property list.
     *
     * @return a list of property names.
     */
    public Iterator getProperties()
    {
        return mMap.keySet().iterator();
    }
}
