/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.logging.*;
import com.sun.logging.*;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.deployment.util.LogDomains;

/**
 * Contains information about a stateful session bean remove method.
 */ 

public class EjbRemovalInfo
{
    private static LocalStringManagerImpl localStrings =
	    new LocalStringManagerImpl(EjbRemovalInfo.class);

    static Logger _logger = LogDomains.getLogger(LogDomains.DPL_LOGGER);

    private MethodDescriptor removeMethod;
    private boolean retainIfException = false;
    private boolean retainIfExceptionSet = false;

    public MethodDescriptor getRemoveMethod() {
        return removeMethod;
    }

    public void setRemoveMethod(MethodDescriptor method) {
        removeMethod = method;
    }

    public boolean getRetainIfException() {
        return retainIfException;
    }

    public void setRetainIfException(boolean flag) {
        retainIfException = flag;
        retainIfExceptionSet = true;
    }

    public boolean isRetainIfExceptionSet() {
        return retainIfExceptionSet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("remove method = " + removeMethod + "\t");
        sb.append("retainIfException = " + retainIfException);
        return sb.toString();
    }
}
    
