/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;


    /** 
    * I represent the information about how the web application's data should be protected. 
    *
    * @author Danny Coward
    */
    
public class UserDataConstraintImpl extends Descriptor implements UserDataConstraint {
    /** The transport is unspecified.*/
    public static final String TRANSPORT_GUARANTEE_NONE = UserDataConstraint.NONE_TRANSPORT;
    /** HTTP.*/
    public static final String TRANSPORT_GUARANTEE_INTEGRAL = UserDataConstraint.INTEGRAL_TRANSPORT;
    /** HTTPS */
    public static final String TRANSPORT_GUARANTEE_CONFIDENTIAL = UserDataConstraint.CONFIDENTIAL_TRANSPORT;

    /** JACC Specific **/
    public static final String TRANSPORT_GUARANTEE_CLEAR = UserDataConstraint.CLEAR;
    private static final String[] transportGuaranteeChoices = {
	TRANSPORT_GUARANTEE_NONE,
	TRANSPORT_GUARANTEE_INTEGRAL,
	TRANSPORT_GUARANTEE_CONFIDENTIAL,
    };
    private String transportGuarantee;
    private static LocalStringManagerImpl localStrings =
	    new LocalStringManagerImpl(UserDataConstraintImpl.class);

    /**
    * Return a String array of my static transport types.
    */
    public static final String[] getTransportGuaranteeChoices() {
	return  transportGuaranteeChoices;
    }
    
    /**
    * Return my transport type.
    */
    public String getTransportGuarantee() {
	if (transportGuarantee == null) {
	   transportGuarantee = TRANSPORT_GUARANTEE_NONE;
	}
	return transportGuarantee;
    }

    public String[] getUnacceptableTransportGuarantees(){
	String acceptable = getTransportGuarantee();
	if(acceptable.equals(TRANSPORT_GUARANTEE_NONE))
	   return (String[]) null;
	else if (acceptable.equals(TRANSPORT_GUARANTEE_INTEGRAL)){
	    String[] ret = new String[] {TRANSPORT_GUARANTEE_CLEAR,  TRANSPORT_GUARANTEE_CONFIDENTIAL };
	    return ret;
	} else if (acceptable.equals(TRANSPORT_GUARANTEE_CONFIDENTIAL)){
	    String[] ret = new String[] {TRANSPORT_GUARANTEE_CLEAR,  TRANSPORT_GUARANTEE_INTEGRAL };
	    return ret;
	}
	return (String[]) null;
    }
    /**
    * Sets my transport type to the given value. Throws an illegal argument exception
    * if the value is not allowed.
    */
    public void setTransportGuarantee(String transportGuarantee) {
	if (this.isBoundsChecking()) {
	    if ( !UserDataConstraint.NONE_TRANSPORT.equals(transportGuarantee)
		&& !UserDataConstraint.INTEGRAL_TRANSPORT.equals(transportGuarantee)
		    && !UserDataConstraint.CONFIDENTIAL_TRANSPORT.equals(transportGuarantee)) {
		throw new IllegalArgumentException(localStrings.getLocalString(
									       "enterprise.deployment.exceptiontransportguarentee",
									       "{0} is not a valid transport guarantee", new Object[] {transportGuarantee}));  
	    }
	}
	this.transportGuarantee = transportGuarantee;
    }
    
    /**
    * Returns a formatted String of my state.
    */
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("UserDataConstraint ");
	toStringBuffer.append(" description ").append(super.getDescription());
	toStringBuffer.append(" transportGuarantee ").append(getTransportGuarantee());
    }
}
