/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;

/**
 * Implementation of the Scanner interface for Ejb jar.
 *
 * @author Shing Wai Chan
 */
public class EjbJarScanner extends ModuleScanner {
    public EjbJarScanner(File archiveFile, EjbBundleDescriptor desc)
            throws IOException {
        this(archiveFile, desc, null);
    }

    /**
     * This scanner will scan the archiveFile for annotation processing.
     * @param archiveFile
     * @param classLoader
     */
    public EjbJarScanner(File archiveFile, EjbBundleDescriptor desc, 
        ClassLoader classLoader) throws IOException {
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archiveFile);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        this.archiveFile = archiveFile;
        this.classLoader = classLoader;
        if (archiveFile.isDirectory()) {
            addScanDirectory(archiveFile);

            // always add session beans, message driven beans,
            // interceptor classes that are defined in ejb-jar.xml r
            // regardless of they have annotation or not
            for (Iterator ejbs = desc.getEjbs().iterator(); ejbs.hasNext();) {
                EjbDescriptor ejbDesc = (EjbDescriptor)ejbs.next();
                if (ejbDesc instanceof EjbSessionDescriptor || 
                    ejbDesc instanceof EjbMessageBeanDescriptor) {
                    addScanClassName(ejbDesc.getEjbClassName());
                }
            }

            for (Iterator interceptors = desc.getInterceptors().iterator(); 
                interceptors.hasNext();) {
                EjbInterceptor interceptor = 
                    (EjbInterceptor)interceptors.next();
                addScanClassName(interceptor.getInterceptorClassName());
            }

        } // else in app client jar

    }
}
