/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

import java.util.List;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

import javax.xml.namespace.QName;

import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;

public class WebServiceHandlerChainNode extends DisplayableComponentNode {

    private final static XMLElement tag = 
        new XMLElement(WebServicesTagNames.HANDLER_CHAIN);

    public WebServiceHandlerChainNode() {
        super();
        registerElementHandler
            (new XMLElement(WebServicesTagNames.HANDLER),
             WebServiceHandlerNode.class, "addHandler");
    }

    /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return tag;
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put(WebServicesTagNames.SERVICE_NAME_PATTERN, "setServiceNamePattern");
        table.put(WebServicesTagNames.PORT_NAME_PATTERN, "setPortNamePattern");
        table.put(WebServicesTagNames.PROTOCOL_BINDINGS, "setProtocolBindings");
        return table;
    }

    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
        super.setElementValue(element, value);
    }
    
    /**
     * write the method descriptor class to a query-method DOM tree and 
     * return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, 
                                WebServiceHandlerChain handler) {        
        Node wshNode = super.writeDescriptor(parent, nodeName, handler);

        if(handler.getServiceNamePattern() != null) {
            appendTextChild(wshNode, 
                        WebServicesTagNames.SERVICE_NAME_PATTERN,
                        handler.getServiceNamePattern());
        }
        if(handler.getPortNamePattern() != null) {
            appendTextChild(wshNode, 
                        WebServicesTagNames.PORT_NAME_PATTERN,
                        handler.getPortNamePattern());
        }
        if(handler.getProtocolBindings() != null) {
            appendTextChild(wshNode, 
                        WebServicesTagNames.PROTOCOL_BINDINGS,
                        handler.getProtocolBindings());
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(wshNode, handler.getHandlers());
        return wshNode;
    }    

    public void writeWebServiceHandlerChains(Node parent, List handlerChain) {
        // If there are HanderChains, add the <handler-chains> node before adding
        // individual <handler-chain> nodes
        if(handlerChain.size() != 0) {
            parent = super.writeDescriptor(parent, WebServicesTagNames.HANDLER_CHAINS, null);
        }
        for(Iterator iter = handlerChain.iterator(); iter.hasNext();) {
            WebServiceHandlerChain next = (WebServiceHandlerChain) iter.next();
            writeDescriptor(parent, WebServicesTagNames.HANDLER_CHAIN, next);
        }
    }

}
