/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.connector;

import java.util.*;
import org.xml.sax.Attributes;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.xml.ConnectorTagNames;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ConfigurableNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.ConnectorDescriptor;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;


/**
 * This node is responsible for handling the Connector DTD related inbound-resourceadapter XML tag
 *
 * @author  Sheetal Vartak
 * @version 
 */
public class InBoundRANode extends DeploymentDescriptorNode {
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    

    private InboundResourceAdapter descriptor = null;

    //default constructor
    public InBoundRANode() {
	registerElementHandler(new XMLElement(ConnectorTagNames.MSG_LISTENER),
			       MessageListenerNode.class); 
    }

    /**
     * SAX Parser API implementation, we don't really care for now.
     */
     public void startElement(XMLElement element, Attributes attributes) {
     }

    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */ 
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
	return table;
    } 

    /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor==null) {
	    // the descriptor associated with the InBoundRANode is a InboundResourceAdapter 
	    // This descriptor is available with the parent node of the InBoundRANode
	    descriptor = (InboundResourceAdapter)DescriptorFactory.getDescriptor(getXMLPath());
	    ((ConnectorDescriptor)(getParentNode().getDescriptor())).setInboundResourceAdapter(descriptor);
		   
        } 
        return descriptor;
    }

     /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */
    public void addDescriptor(Object obj) {
	if (obj instanceof MessageListener) {
	    descriptor.addMessageListener((MessageListener)obj);
	}
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node connectorNode, Descriptor descriptor) {  
	Node inBoundNode = appendChild(connectorNode, ConnectorTagNames.INBOUND_RESOURCE_ADAPTER);
	appendInBoundNode(inBoundNode, (InboundResourceAdapter)((ConnectorDescriptor)descriptor).getInboundResourceAdapter());
	return connectorNode;
    }

    /**
     * method to add the child nodes of INBOUND_RESOURCE_ADAPTER
     */
    private void appendInBoundNode (Node inBoundNode, InboundResourceAdapter conDesc) {

	Node msgAdapter = appendChild(inBoundNode, ConnectorTagNames.MSG_ADAPTER);

	MessageListenerNode msgListener = new MessageListenerNode();
	msgAdapter = msgListener.writeDescriptor(msgAdapter, conDesc);
    }    

}
