/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ExcludeListNode.java
 *
 * Created on January 23, 2002, 4:35 PM
 */

package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermissionDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.xml.EjbTagNames;

/**
 * This class is responsible for handling the exclude-list DD tag
 *
 * @author  Jeromeochez
 * @version 
 */
public class ExcludeListNode extends DeploymentDescriptorNode {

    private MethodPermissionDescriptor descriptor;
    
    /** Creates new ExcludeListNode */
    public ExcludeListNode() {
       registerElementHandler(new XMLElement(EjbTagNames.METHOD), 
                                                            MethodNode.class, "addMethod");                                 
    }
    

    /**
     * @return the Descriptor subclass that was populated  by reading
     * the source XML file
     */
    public Object getDescriptor() {
        if (descriptor==null) {
            descriptor = (MethodPermissionDescriptor) DescriptorFactory.getDescriptor(getXMLPath());
            descriptor.addMethodPermission(MethodPermission.getExcludedMethodPermission());
        }
        return descriptor;
    }    
}
