/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
/**
* node for web property tag
*
* @author Jerome Dochez
*/
public class LocaleCharsetMapNode extends WebRuntimeNode {
    
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
	RuntimeDescriptor descriptor = getRuntimeDescriptor();
	if (descriptor==null) {
	    throw new RuntimeException("Trying to set name or value on null property");
	}
	if (element.getQName().equals(RuntimeTagNames.LOCALE)) {
	    descriptor.setAttributeValue(LocaleCharsetMap.LOCALE, value);
	} else 
	if (element.getQName().equals(RuntimeTagNames.AGENT)) {
	    descriptor.setAttributeValue(LocaleCharsetMap.AGENT, value);
	}
	if (element.getQName().equals(RuntimeTagNames.CHARSET)) {
	    descriptor.setAttributeValue(LocaleCharsetMap.CHARSET, value);
	} 
    }    
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, LocaleCharsetMap descriptor) {
	
	Element locale = (Element) super.writeDescriptor(parent, nodeName, descriptor);
	
	// description?
	appendTextChild(locale, RuntimeTagNames.DESCRIPTION, descriptor.getDescription());
	
	// locale, agent, charset attributes
	setAttribute(locale, RuntimeTagNames.LOCALE, (String) descriptor.getAttributeValue(LocaleCharsetMap.LOCALE));
	setAttribute(locale, RuntimeTagNames.AGENT, (String) descriptor.getAttributeValue(LocaleCharsetMap.AGENT));
	setAttribute(locale, RuntimeTagNames.CHARSET, (String) descriptor.getAttributeValue(LocaleCharsetMap.CHARSET));
	
	return locale;
    }
}
