/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.util;

import java.util.logging.Level;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;

import java.net.URL;
import java.net.URLConnection;
import java.net.MalformedURLException;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.util.FileUtil;

/**
 *
 * @author Kenneth Saks
 */
public class ModuleContentLinker extends DefaultDOLVisitor {

    // For standalone modules, this is either a directory or a jar file.
    // For .ears, this is the directory used by the j2ee classloader.
    protected FileArchive rootLocation_;

    public ModuleContentLinker(FileArchive rootLocation) {
        rootLocation_ = rootLocation;
    }
    
    protected ModuleContentLinker() {
    }

    private File getModuleLocation(ModuleDescriptor module) throws IOException {
        File moduleLocation = new File(rootLocation_.getArchiveUri());
        if( !module.isStandalone() ) {
            // If this is an ear, get module jar by adding the module path
            // to the root directory.
            String archiveUri = module.getArchiveUri();
            moduleLocation = new File(rootLocation_.getEmbeddedArchive(archiveUri).getArchiveUri());
        }
        return moduleLocation;
    }

    private URL internalGetUrl(ModuleDescriptor module, String uri) 
        throws Exception {
        File moduleLocation = getModuleLocation(module);
        URL url = FileUtil.getEntryAsUrl(moduleLocation, uri);
        return url;
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        try {
            ModuleDescriptor moduleDesc = 
                serviceRef.getBundleDescriptor().getModuleDescriptor();

            if( serviceRef.hasWsdlFile() ) {
                
                String wsdlFileUri = serviceRef.getWsdlFileUri();
                File tmpFile = new File(wsdlFileUri);
                if(tmpFile.isAbsolute()) {
                    // This takes care of the case when we set wsdlFileUri from generated @WebClient
                    // and the uri is an absolute path
                    serviceRef.setWsdlFileUrl(tmpFile.toURI().toURL());
                } else {
                    // If the given WSDL is an http URL, create a URL directly from this
                    if(wsdlFileUri.startsWith("http")) {
                        serviceRef.setWsdlFileUrl(new URL(wsdlFileUri));
                    } else {
                        // Given WSDL location is a relative path - append this to the module dir
                        File wsdlFile = new File(getModuleLocation(moduleDesc), wsdlFileUri);                
                        URL wsdlFileUrl = internalGetUrl(moduleDesc, wsdlFileUri);
                        serviceRef.setWsdlFileUrl(wsdlFile.toURI().toURL());
                    }
                }
            }
            if( serviceRef.hasMappingFile() ) {
                String mappingFileUri = serviceRef.getMappingFileUri();
                File mappingFile = new File(getModuleLocation(moduleDesc), mappingFileUri);
                serviceRef.setMappingFile(mappingFile);

            } 
        } catch (java.net.MalformedURLException mex) {
            DOLUtils.getDefaultLogger().log
                (Level.SEVERE, "enterprise.deployment.backend.invalidWsdlURL",
                new Object[] {serviceRef.getWsdlFileUri()});            
        } catch(Exception e) {
            DOLUtils.getDefaultLogger().log
                (Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure",
                new Object[] {serviceRef.getName() , rootLocation_});
        }
    }

    public void accept(WebService webService) {
        try {
            ModuleDescriptor moduleDesc = 
                webService.getBundleDescriptor().getModuleDescriptor();

            if( webService.hasWsdlFile() && webService.getWsdlFileUrl()==null) {
                String wsdlFileUri = webService.getWsdlFileUri();
                URL wsdlFileURL=null;
                try {
                    URL url = new URL(wsdlFileUri);
                    if (url.getProtocol()!=null && !url.getProtocol().equalsIgnoreCase("file")) {
                        wsdlFileURL=url;
                    } 
                } catch(java.net.MalformedURLException e) {
                    // ignore, it could just be a relate URI
                }
                if (wsdlFileURL==null) {
                    File wsdlFile = new File(getModuleLocation(moduleDesc), wsdlFileUri);                        
                    wsdlFileURL = wsdlFile.toURI().toURL();
                }
                webService.setWsdlFileUrl(wsdlFileURL);
            }
            if( webService.hasMappingFile() ) {
                String mappingFileUri = webService.getMappingFileUri();
                File mappingFile = new File(getModuleLocation(moduleDesc), mappingFileUri);
                webService.setMappingFile(mappingFile);
            } 
        } catch(Exception e) {
            DOLUtils.getDefaultLogger().log
                (Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure",
                new Object[] {webService.getName() , rootLocation_});
        } 
    }

}
