/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.io.IOException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class FileClassLoader extends ClassLoader {
    String codebase;
    Hashtable cache = new Hashtable();

    private static LocalStringManagerImpl localStrings =
        new LocalStringManagerImpl(FileClassLoader.class);

    public FileClassLoader(String codebase)
    {
	this.codebase = codebase;
    }

    private byte[] loadClassData(String name)
	throws IOException
    {
        // load the class data from the codebase
	String sep = System.getProperty("file.separator");
	String c = name.replace('.', sep.charAt(0)) + ".class";
	File file = new File(codebase + sep + c);
	if (!file.exists()) {
	    File wf = new File(codebase + sep + "WEB-INF" + sep + "classes" + sep + c);
	    if (wf.exists()) {
		file = wf;
	    }
	}
	FileInputStream fis = new FileInputStream(file);
	int avail = fis.available();
	byte[] buf = new byte[avail];
	fis.read(buf);
        fis.close();
	return buf;
    }
    
    String getClassName(File f) throws IOException, ClassFormatError {
	FileInputStream fis = new FileInputStream(f);
	int avail = fis.available();
	byte[] buf = new byte[avail];
	fis.read(buf);
        fis.close();
	Class c = super.defineClass(null, buf, 0, avail);
	return c.getName();
    }

    /**
     * @exception ClassNotFoundException if class load fails
     */
    public synchronized Class loadClass(String name, boolean resolve) 
	throws ClassNotFoundException
    {
        Class c = (Class)cache.get(name);
        if (c == null) {
	    try { 
                byte data[] = loadClassData(name);
                c = defineClass(null,data, 0, data.length);
                if( !name.equals(c.getName()) ) {
                    throw new ClassNotFoundException(localStrings.getLocalString("classloader.wrongpackage", "", new Object[] { name, c.getName() }));
                }
	    }
	    catch ( Exception ex ) {
		// Try to use default classloader. If this fails, 
		// then a ClassNotFoundException is thrown.
		c = Class.forName(name);
	    }
            cache.put(name, c);
        }
        if (resolve)
            resolveClass(c);
        return c;
    }

    public String toString()
    {
	return "FileClassLoader: Codebase = "+codebase+"\n";
    }
}
