/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * WebServiceEngine.java
 *
 * Created on March 10, 2005, 3:36 PM
 */

package com.sun.enterprise.webservice.monitoring;

import java.util.Iterator;

/**
 * This interface holds all behaviour associated with the 
 * web service engine. For instance, it gives a list of all 
 * registered endoints, provide hooks to register listener
 * interfaces for endpoints creation/deletion and so on...
 *
 * @author Jerome Dochez
 */
public interface WebServiceEngine {
    
    /**
     * @return an iterator of all the registered active endpoints in 
     * the engine.
     */
    public Iterator<Endpoint> getEndpoints();
    
    /**
     * @return an Endpoint instance if the supplied selector is the endpoint's
     * invocation selector. In case of HTTP based web services, the selector is
     * the endpoint URL
     * @param endpointSelector the endpoint selector
     */
    public Endpoint getEndpoint(String endpointSelector);
    
    /**
     * Register a new listener interface to receive notification of 
     * web service endpoint creation and deletion
     * @param listener instance to register
     */
    public void addLifecycleListener(EndpointLifecycleListener listener);
    
    /**
     * Unregister a listener interface 
     * @param listener to unregister.
     */
    public void removeLifecycleListener(EndpointLifecycleListener listener);
    
    /**
     * Register a new listener interface to receive authentication 
     * notification. 
     * @param listener to add
     */
    public void addAuthListener(AuthenticationListener listener);
    
    /**
     * Unregister a listener interface
     * @param listener to remove
     */
    public void removeAuthListener(AuthenticationListener listener);
    
    /**
     * Set the unique global listener interface to trace all web service requests 
     * or responses. Set to null if no tracing is needed 
     * @param listener to register
     */
    public void setGlobalMessageListener(GlobalMessageListener listener);
    
    /**
     * get the global listener interface or null if none is set.
     * @return the global message listener
     */
    public GlobalMessageListener getGlobalMessageListener();
    
}
