/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

import com.sun.enterprise.admin.monitor.stats.EJBPoolStats;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import com.sun.enterprise.admin.monitor.stats.EJBPoolStats;
import com.sun.ejb.spi.stats.EJBPoolStatsProvider;

import java.util.logging.*;
import com.sun.enterprise.log.Log;
import com.sun.logging.*;

/**
 * A Class for providing pool stats for EJB Container
 *  Used by both Entity and Stateless Container
 *
 * @author Mahesh Kannan
 */

public class EJBPoolStatsImpl
    extends StatsImpl
    implements com.sun.enterprise.admin.monitor.stats.EJBPoolStats
{
    private EJBPoolStatsProvider delegate;

    private MutableCountStatisticImpl		jmsStat;
    private MutableBoundedRangeStatisticImpl	beansInPoolStat;
    private MutableBoundedRangeStatisticImpl	threadStat;
    private MutableCountStatisticImpl		createdStat;
    private MutableCountStatisticImpl		destroyedStat;

    public EJBPoolStatsImpl(EJBPoolStatsProvider delegate) {
	this.delegate = delegate;

	initialize();
    }

    protected void initialize() {
	super.initialize("com.sun.enterprise.admin.monitor.stats.EJBPoolStats");

	jmsStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("JmsMaxMessagesLoad"));
	beansInPoolStat = new MutableBoundedRangeStatisticImpl(
		new BoundedRangeStatisticImpl("NumBeansInPool",
		    "Count", 0, delegate.getMaxPoolSize(),
		    delegate.getSteadyPoolSize()));
	threadStat = new MutableBoundedRangeStatisticImpl(
		new BoundedRangeStatisticImpl("NumThreadsWaiting"));
	createdStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("TotalBeansCreated"));
	destroyedStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("TotalBeansDestroyed"));
    }

    public CountStatistic getJmsMaxMessagesLoad() {
	jmsStat.setCount(delegate.getJmsMaxMessagesLoad());
	return (CountStatistic) jmsStat.modifiableView();
    }

    public BoundedRangeStatistic getNumBeansInPool() {
	beansInPoolStat.setCount(delegate.getNumBeansInPool());
	return (BoundedRangeStatistic) beansInPoolStat.modifiableView();
    }

    public BoundedRangeStatistic getNumThreadsWaiting() {
	threadStat.setCount(delegate.getNumThreadsWaiting());
	return (BoundedRangeStatistic) threadStat.modifiableView();
    }

    public CountStatistic getTotalBeansCreated() {
	createdStat.setCount(delegate.getTotalBeansCreated());
	return (CountStatistic) createdStat.modifiableView();
    }

    public CountStatistic getTotalBeansDestroyed() {
	destroyedStat.setCount(delegate.getTotalBeansDestroyed());
	return (CountStatistic) destroyedStat.modifiableView();
    }

}
