/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import java.rmi.RemoteException;
import java.lang.reflect.Method;
import javax.ejb.*;

import com.sun.ejb.*;
import com.sun.enterprise.*;

/**
 * Implementation of EJBContext for EntityBeans
 *
 */

public class EntityContextImpl
    extends EJBContextImpl
    implements EntityContext
{
    private int lastTxStatus=-1;
    private boolean newlyActivated = false;
    private int nCallsInProgress = 0;
    private boolean dirty = false;
    private boolean inUnsetEntityContext = false;
    private boolean inEjbLoad = false;
    private boolean inEjbStore = false;
    
    private boolean cascadeDeleteBeforeEJBRemove = false;
    private boolean cascadeDeleteAfterSuperEJBRemove = false;

    //The following member variables are used to directly cache
    //	the EntityContext instead of enclosing it within a wrapper class.
    private Object		    _primaryKey;
    private int			    _pkHashCode;
    private EntityContextImpl	    _next;

    EntityContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
    }
    
    int getLastTransactionStatus() {
        return lastTxStatus;
    }
    
    void setLastTransactionStatus(int status) {
        lastTxStatus = status;
    }
    
    void setInUnsetEntityContext(boolean flag) {
        inUnsetEntityContext = flag;
    }
    
    void setInEjbLoad(boolean flag) {
        inEjbLoad = flag;
    }
    
    void setInEjbStore(boolean flag) {
        inEjbStore = flag;
    }
    
    boolean isDirty() {
        return dirty;
    }
    
    void setDirty(boolean b) {
        dirty = b;
    }
    
    // overrides EJBContextImpl.setState
    void setState(int s) {
        state = s;
        if ( state == EntityContainer.POOLED || 
            state == EntityContainer.DESTROYED )
        {
            dirty = false;
        }
    }
    
    
    boolean isNewlyActivated() {
        return newlyActivated;
    }
    
    void setNewlyActivated(boolean b) {
        newlyActivated = b;
    }
    
    boolean hasReentrantCall() {
        return (nCallsInProgress > 1);
    }
    
    synchronized void decrementCalls() {
        nCallsInProgress--;
    }
    
    synchronized void incrementCalls() {
        nCallsInProgress++;
    }
    
    boolean hasIdentity() {
        return( (ejbObjectImpl != null) || (ejbLocalObjectImpl != null) );
    }
    
    /**
     * Implementation of EntityContext method.
     */
    public Object getPrimaryKey() throws IllegalStateException {
        if ( ejbObjectImpl == null && ejbLocalObjectImpl == null ) {
            // There is no ejbObjectImpl/localObject in ejbCreate, ejbFind,
            // setEntityCtx etc
            throw new IllegalStateException("Primary key not available");
        }
        
        if ( ejbLocalObjectImpl != null )
            return ejbLocalObjectImpl.getKey();
        else
            return ejbObjectImpl.getKey();
    }
    
    /**
     * Implementation of EntityContext method, overrides EJBContextImpl method.
     */
    public EJBObject getEJBObject()
        throws IllegalStateException
    {
        if (! isRemoteInterfaceSupported) {
            throw new IllegalStateException("EJBObject not available");
        }

        if ( ejbStub == null ) {
            Object pkey = getPrimaryKey(); // throws IllegalStateException
            ejbStub = ((EntityContainer) container).getEJBObjectStub(pkey, null);
        }

        return ejbStub;
    }

    public TimerService getTimerService() throws IllegalStateException {
        if( state == NOT_INITIALIZED || inUnsetEntityContext || inFinder() ) {
            throw new IllegalStateException("Operation not allowed");
        }
     
        ContainerFactoryImpl cf = (ContainerFactoryImpl)
            Switch.getSwitch().getContainerFactory();
        EJBTimerService timerService = cf.getEJBTimerService();
        if( timerService == null ) {
            throw new EJBException("EJB Timer service not available");
        }
        return new EJBTimerServiceWrapper(timerService,
                                          (EntityContextImpl) this);
    }
    
    protected void checkAccessToCallerSecurity()
        throws IllegalStateException
    {
        if( state == NOT_INITIALIZED || inUnsetEntityContext ) {
            throw new IllegalStateException("Operation not allowed");
        }
        checkActivatePassivate();
        
        if (inEjbLoad || inEjbStore) {
            // Security access is allowed from these two methods.  In the
            // case that they are invoked as part of an ejbTimeout call,
            // getCallerPrincipal will return null and isCallerInRole will
            // be false
            return;
        }
    }
    
    public void checkTimerServiceMethodAccess()
        throws IllegalStateException
    {
        
        // Prohibit access from constructor, setEntityContext, ejbCreate,
        // ejbActivate, ejbPassivate, unsetEntityContext, ejbFind
        if( (state == NOT_INITIALIZED) ||
        inUnsetEntityContext ||
        inFinder() ||
        inActivatePassivate() ||
        !hasIdentity() ) {
            throw new IllegalStateException("Operation not allowed");
        }
        
    }
    
    public final boolean isCascadeDeleteAfterSuperEJBRemove() {
        return cascadeDeleteAfterSuperEJBRemove;
    }

    public final void setCascadeDeleteAfterSuperEJBRemove(boolean value) {
        this.cascadeDeleteAfterSuperEJBRemove = value;
    }

    public final boolean isCascadeDeleteBeforeEJBRemove() {
        return cascadeDeleteBeforeEJBRemove;
    }

    public final void setCascadeDeleteBeforeEJBRemove(boolean value) {
        this.cascadeDeleteBeforeEJBRemove = value;
    }

    private boolean inFinder() {
        boolean inFinder = false;
        ComponentInvocation i = 
            container.invocationManager.getCurrentInvocation();
        if ( i instanceof Invocation ) {
            Invocation inv = (Invocation) i;
            Method currentMethod = inv.method;
            inFinder = ( (currentMethod != null) && inv.isHome &&
                         currentMethod.getName().startsWith("find") );
        }
        return inFinder;
    }

    //Called from EntityContainer after an ejb is obtained from the pool.
    final void cachePrimaryKey() {
	Object pk = getPrimaryKey();
	this._primaryKey = pk;
	this._pkHashCode = pk.hashCode();
    }

    final void clearCachedPrimaryKey() {
	this._primaryKey = null;
    }

    //Called from IncompleteTxCache to get an already cached context
    final boolean doesMatch(BaseContainer baseContainer, int pkHashCode, Object pk) {
	return (
	    (container == baseContainer)
	    && (_pkHashCode == pkHashCode)
	    && (_primaryKey.equals(pk))
	);
    }

    final void _setNext(EntityContextImpl val) {
	this._next = val;
    }

    final EntityContextImpl _getNext() {
	return _next;
    }

    final int _getPKHashCode() {
	return this._pkHashCode;
    }

}
