/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.util.*;
import javax.transaction.*;
import com.sun.enterprise.*;


/**
 * A "wrapper" implementation of javax.transaction.TransactionManager 
 * used by the container to communicate with the PersistenceManager.
 * The PM can only call getTransaction and getStatus methods.
 * This object is available at the JNDI name "java:pm/TransactionManager".
 */
public class PMTransactionManagerImpl implements TransactionManager, 
						 java.io.Serializable {

    transient private TransactionManager transactionManager = null;

    /**
     * Create a transaction manager instance
     */
    PMTransactionManagerImpl() {}

    /**
     * Obtain the status of the transaction associated with the current thread.
     * 
     * @return The transaction status. If no transaction is associated with 
     *    the current thread, this method returns the Status.NoTransaction 
     *    value.
     */
    public int getStatus() throws SystemException 
    {
	if ( transactionManager == null )
	    transactionManager = Switch.getSwitch().getTransactionManager();
	return transactionManager.getStatus();
    }

    /**
     * Get the transaction object that represents the transaction 
     * context of the calling thread
     */
    public Transaction getTransaction() throws SystemException 
    {
	if ( transactionManager == null )
	    transactionManager = Switch.getSwitch().getTransactionManager();
	Transaction tx = transactionManager.getTransaction();
	if ( tx == null )
	    return null;
	else
	    return new PMTransactionImpl(tx);
    }


    public void begin() 
        throws IllegalStateException, SystemException {

        throw new IllegalStateException("Operation not allowed");
    }

    public void commit() throws RollbackException, 
	HeuristicMixedException, HeuristicRollbackException,
        SecurityException, IllegalStateException, SystemException {

        throw new IllegalStateException("Operation not allowed");
    }

    public void rollback() 
        throws IllegalStateException, SecurityException, SystemException {

        throw new IllegalStateException("Operation not allowed");
    }

    public void setRollbackOnly() 
        throws IllegalStateException, SystemException {

        throw new IllegalStateException("Operation not allowed");
    }

    public void resume(Transaction suspended) throws
        InvalidTransactionException, IllegalStateException, SystemException {

        throw new IllegalStateException("Operation not allowed");
    }

    public Transaction suspend() throws SystemException {
        throw new IllegalStateException("Operation not allowed");
    }

    public void setTransactionTimeout(int seconds)
        throws SystemException {

        throw new IllegalStateException("Operation not allowed");
    }

}

