/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.rmi.Remote;

import java.io.ObjectInputStream;
import java.io.WriteAbortedException;
import java.io.ObjectStreamException;
import java.io.IOException;

import com.sun.ejb.EJBUtils;

public class RemoteBusinessWrapperBase 
    implements java.io.Serializable {

    // This is the name of the developer-written business interface.
    private String businessInterface_;

    private Remote stub_;
    
    private transient int hashCode_;

    public RemoteBusinessWrapperBase(Remote stub, String busIntf) {
        stub_ = stub;
        businessInterface_ = busIntf;
        this.hashCode_ = busIntf.hashCode();
    }

    public Remote getStub() {
        return stub_;
    }
    
    public int hashCode() {
        return hashCode_;
    }

    public boolean equals(Object obj) {
        
        boolean result = (obj == this); //Most efficient
        if ((result == false) && (obj != null)) { //Do elaborate checks
            if (obj instanceof RemoteBusinessWrapperBase) {
                RemoteBusinessWrapperBase remoteBWB =
                        (RemoteBusinessWrapperBase) obj;
                boolean hasSameBusinessInterface =
                        (remoteBWB.hashCode_ == hashCode_) &&
                        remoteBWB.businessInterface_.equals(businessInterface_);
                if (hasSameBusinessInterface) {
                    org.omg.CORBA.Object other = (org.omg.CORBA.Object) remoteBWB.stub_;
                    org.omg.CORBA.Object me = (org.omg.CORBA.Object) stub_;
                    result = me._is_equivalent(other);
                }
            }
        }
        
        return result;
    }
    
    public String getBusinessInterfaceName() {
        return businessInterface_;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new RemoteBusinessWrapperBase(stub_, businessInterface_); 
    }

    private void writeObject(java.io.ObjectOutputStream oos) 
        throws java.io.IOException 
    {

        oos.writeObject(businessInterface_);
        oos.writeObject(stub_);

    }

    private void readObject(ObjectInputStream ois) 
        throws IOException, ClassNotFoundException {

        try {

            businessInterface_ = (String) ois.readObject();
            hashCode_ = businessInterface_.hashCode();

            EJBUtils.loadGeneratedRemoteBusinessClasses(businessInterface_);

            stub_ = (Remote) ois.readObject();

        } catch(Exception e) {
            IOException ioe = new IOException("RemoteBusinessWrapper.readObj "
                                              + " error");
            ioe.initCause(e);
            throw ioe;
        }
    }
                 
    public Object readResolve() throws ObjectStreamException {

        try {

            return EJBUtils.createRemoteBusinessObject(businessInterface_,
                                                       stub_);
        } catch(Exception e) {
            WriteAbortedException wae = new WriteAbortedException
                ("RemoteBusinessWrapper.readResolve error", e);
            wae.initCause(e);
            throw wae;
        }

    }
                



}

