/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers.util.cache;

public class CacheEntry {

    public Object 	key;
    public Object 	value;
    public int		keyHashCode;
    public CacheEntry 	next;

    public CacheEntry	before;
    public CacheEntry	after;

    /**
     * Create new entry.
     */
    public CacheEntry(Object k, Object v, CacheEntry n) { 
        key = k;
        keyHashCode = k.hashCode();
        value = v; 
        next = n;
    }

    public CacheEntry(Object k, int kh, Object v, CacheEntry n) { 
        key = k;
        keyHashCode = kh;
        value = v; 
        next = n;
    }

    public CacheEntry initialize(Object k, Object v, CacheEntry n) { 
        key = k;
        keyHashCode = k.hashCode();
        value = v; 
        next = n;
        
        return this;
    }
    
    public CacheEntry initialize(Object k, int kh, Object v, CacheEntry n) { 
        key = k;
        keyHashCode = kh;
        value = v; 
        next = n;
        
        return this;
        
    }
    
    public int hashCode() {
        return keyHashCode;
    }
    
    public String toString() {
        return key + "=" + value;
    }

}


