/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.container;

import javax.ejb.DuplicateKeyException;

/**
 * There are cases where the container would need to interact with the 
 * persistence manager. Some known cases are listed below
 * 1. provide the user with a mechanism to flush changes to the database 
 *    at the end of a method with out waiting until the end of the transaction. 
 * 2. for read only beans provide a mechanism to have the master copy of the bean  
 *    sync up with the database record.
 *
 * Currently the bean concrete implementation that is created as part of the codegen
 * would implement this interface. 
 *
 * @author Pramod Gopinath
 */


public interface BeanStateSynchronization {
    /**
     * Provides a mechanism to flush changes to the database w/o waiting for
     * the end of the transaction, based on some descriptor values set by the user. 
     * The container would call this method in the postInvoke(), only if the flush
     * is enabled for the current method and there were no other exceptions set 
     * into inv.exception.
     */
    public void ejb__flush() 
        throws DuplicateKeyException;

    /**
     * On receiving this message the PM would update its master copy
     * by fetching the latest information for the primary key from the database
     */
    public void ejb__refresh(Object primaryKey);


    /**
     * On receiving this message the PM would delete from its master copy
     * the details related to the primaryKey
     */
    public void ejb__remove(Object primaryKey);
}
