/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.exception;

/**
 */
public class JMSAdminException extends AFException
{

    /**
     * Exception reference
     **/
    private Exception linkedException;
    private String _message = null;

    /**
     * Constructs an JMSAdminException object
     */
    public JMSAdminException()
    {
        super();
        linkedException = null;
    }

    /**
     * Constructs an JMSAdminException object
     * @param message Exception message
     */
    public JMSAdminException(String message)
    {
        super(message);
	_message = message;
        linkedException = null;
    }

    /**
     * Gets the exception linked to this one
     *
     * @return the linked Exception, null if none
     **/
    public Exception getLinkedException() {
        return (linkedException);
    }

    /**
     * Adds a linked Exception
     *
     * @param ex       the linked Exception
     **/
    public synchronized void setLinkedException(Exception ex) {
        linkedException = ex;
    }

    /**
     * Returns the message along with the message from any linked exception.
     *
     **/
    public String getMessage() {
	String retString = null;

	// Return the message of this exception.
	if (_message != null) {
	   retString = _message;
	}

	// Append any message from the linked exception.
	if (linkedException != null && linkedException.getMessage() != null) {
	    if (retString != null) {
	        retString += retString + "\n" + linkedException.getMessage();
	    } else {
	        retString = linkedException.getMessage();
	    }
	}

	return retString;
        
    }

}
