/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event;

import java.util.List;
import java.util.ArrayList;
import com.sun.enterprise.config.ConfigContext;

/**
 * This object encapsulates event related information in the thread local.
 *
 * @author Nazrul Islam
 * @since  JDK1.4
 */
public class EventStack {

    /**
     * Returns the config changes associated with this event.
     * @return  list of config changes
     */
    public List getConfigChangeList() {
        return _configChangeList;
    }

    /**
     * Sets the config changes for this event.
     * @param  list  list of config changes
     */
    public void setConfigChangeList(List list) {
        _configChangeList = list;
    }

    /**
     * Returns the target for this event.
     * @return  the target for this event
     */
    public String getTarget() {
        return _target;
    }

    /**
     * Sets the target destination for this event.
     * @param  target  target destination of the event
     */
    public void setTarget(String target) {
        _target = target;
    }

    public String getXPath() {
        return _xPath;
    }

    public void setXPath(String xPath) {
        _xPath = xPath;
    }

    /**
     * Returns all events from the stack.
     * @return  list of events from the stack
     */
    public List getEvents() {
        return _events;
    }

    /**
     * Adds an event to the event stack.
     * @param  event  newly created event 
     */
    public void addEvent(AdminEvent event) {
        _events.add(event);
    }

    /** 
     * Returns the admin config context associated with this event.
     * @return  admin config context
     */
    public ConfigContext getConfigContext() {
        return _ctx;
    }

    /**
     * Sets the admin config context to the event stack.
     * @param  ctx  admin config context
     */
    public void setConfigContext(ConfigContext ctx) {
        _ctx = ctx;
    }

    /**
     * resets the events in the event stack.
     */
    public void resetEvents() {
        _events.clear();
    }
    
    // ---- VARIABLES - PRIVATE --------------------------- 
    private List _configChangeList = new ArrayList();
    private String _target         = null;
    private String _xPath          = null;
    private List _events           = new ArrayList();
    private ConfigContext _ctx     = null;
}
