/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LifeCycleEvent.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;

import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.NotificationFilter;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;



/**
 *
 * @author Sun Micro Systems, Inc
 */
public class LifeCycleEvent implements Event {
    
    private static Logger _logger = LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
    private static StringManager sm = StringManager.getManager(LifeCycleEvent.class);
    
    public LifeCycleEvent(String type, LifeCycleNotificationFilter lfilter, String description) {
        this.type = type;
        this.lfilter = lfilter;
        if (description != null)
            this.description = description;
        else
            this.description = defaultDescription;
    }
    
    public ObjectName getObjectName() {
        return objName;
    }
    
    
    public String getType() {
        return type;
    }
    
    public NotificationFilter getNotificationFilter( ){
        return lfilter;
    }
    
    public String getDescription() {
        return description;
    }
    
    public void destroy() {
        // do nothing
    }
    
    static ObjectName getLifeCycleImplObjectName() {
        if (objName != null)
            return objName;
        try {
            objName =  new ObjectName( DOMAIN_NAME,DEFAULT_KEY, "lifecycle");
        }catch (MalformedObjectNameException mex) {
            _logger.log(Level.WARNING,"smgt.internal_error", mex);
        }
        return objName;
    }

    public static boolean isValidType(String type) {
        if ("*".equals(type) || READY_EVENT.equals(type) ||
                SHUTDOWN_EVENT.equals(type) || TERMINATION_EVENT.equals(type) ) {
            return true;
        }
        return false;
    }
    
    private static ObjectName objName = null;
    private static String defaultDescription =
            sm.getString("selfmgmt_event.lifecycle_event_description");
    private LifeCycleNotificationFilter lfilter = null;
    private String description = null;
    private String type = null;

    /**
     * Constant to denote the eventType ready
     */
    public static final String READY_EVENT = "lifecycle.ready";
                                                                                                                                               
    /**
     * Constant to denote the eventType shutdown
     */
    public static final String SHUTDOWN_EVENT = "lifecycle.shutdown";
                                                                                                                                               
    /**
     * Constant to denote the eventType termination
     */
    public static final String TERMINATION_EVENT = "lifecycle.termination";

}
