/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.selfmanagement.event;

import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.MBeanNotificationInfo;
import com.sun.enterprise.server.ServerContext;



/**
 * LifeCycleImpl is an MBean that implements the LifecycleListener
 * interface and is a subclass of NotificationBroadcasterSupport.
 */
public class LifeCycleImpl extends NotificationBroadcasterSupport implements LifeCycleImplMBean {
    
    public LifeCycleImpl() {
        DeclarativeLifecycleEventService.setLifeCycleImpl(this);
    }
    
    /**
     * Notification sequence number within the source object.
     */
    private long sequenceNumber = 0;
    
    
    public void onReady(ServerContext sc) {
        long seqno;
        synchronized (this) {
            seqno = sequenceNumber++;
        }
        //LifeCycleNotification n = new LifeCycleNotification(LifeCycleNotification.READY_EVENT, this, seqno, "Ready!!!");
        Notification n = new Notification(LifeCycleEvent.READY_EVENT, this, seqno, "Ready!!!");
        sendNotification(n);
        
    }
    
    public void onShutdown() {
        long seqno;
        synchronized (this) {
            seqno = sequenceNumber++;
        }
        //LifeCycleNotification n = new LifeCycleNotification(LifeCycleNotification.SHUTDOWN_EVENT, this, seqno, "Shutting Down!!!");
        Notification n = new Notification(LifeCycleEvent.SHUTDOWN_EVENT, this, seqno, "Shutting Down!!!");
	sendNotification(n);
        
    }
    
    public void onTermination() {
        long seqno;
        synchronized (this) {
            seqno = sequenceNumber++;
        }
        //LifeCycleNotification n = new LifeCycleNotification(LifeCycleNotification.TERMINATION_EVENT, this, seqno, "Terminated!!!");
        Notification n = new Notification(LifeCycleEvent.TERMINATION_EVENT, this, seqno, "Terminated!!!");
        sendNotification(n);
        
    }
    
    
    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }
    
    private static final String[] types =  {
        LifeCycleEvent.READY_EVENT,
                LifeCycleEvent.SHUTDOWN_EVENT,
                LifeCycleEvent.TERMINATION_EVENT
    };
    
    
    private static final MBeanNotificationInfo[] notifsInfo = {
        new MBeanNotificationInfo(
                types,
                "javax.management.Notification",
                "Notifications sent by the LifeCycleImpl MBean")
    };
    
    
}
