/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: DomainTarget.java,v 1.3 2005/12/25 04:14:39 tcfujii Exp $
 */

package com.sun.enterprise.admin.target;

//jdk imports
import java.io.Serializable;

//config imports
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.ApplicationRef;

public class DomainTarget extends Target
{
    /**
     * i18n strings manager object
     */
    private static final StringManager strMgr = 
        StringManager.getManager(DomainTarget.class);

    protected DomainTarget(String name, ConfigContext cc)
    {
        super(name, cc);
    }

    public TargetType getType()
    {
        return TargetType.DOMAIN;
    }

    public String getTargetObjectName(String[] tokens)
    {
        checkTokens(tokens, 1);
        return (tokens[0] + ":type=domain,category=config");
    }

    public ConfigTarget getConfigTarget() throws Exception
    {
        throw new Exception(strMgr.getString("target.no_config_for_domain"));
    }

    public String getConfigRef() throws ConfigException
    {
        return null;
    }
    
    /**
     * Get all servers in the domain
     */
    public Server[] getServers() throws ConfigException
    {
        return ServerHelper.getServersInDomain(getConfigContext());
    }
    
    /**
     * Return all the clusters in the domain
     */    
    public Cluster[] getClusters() throws ConfigException
    {
        return ClusterHelper.getClustersInDomain(getConfigContext());
    }
    
    /**
     * Return all the configurations in the domain
     */    
    public Config[] getConfigs() throws ConfigException
    {
        return ConfigAPIHelper.getConfigsInDomain(getConfigContext());
    }
    
    /**
     * Return all the node agents in the domain
     */    
    public NodeAgent[] getNodeAgents() throws ConfigException
    {
        return NodeAgentHelper.getNodeAgentsInDomain(getConfigContext());        
    }
    
    public ApplicationRef[] getApplicationRefs() throws ConfigException
    {
        throw new ConfigException(strMgr.getString("target.not_supported",
            "getApplicationRefs", getType().getName()));
    }
    
    public ResourceRef[] getResourceRefs() throws ConfigException
    {
        throw new ConfigException(strMgr.getString("target.not_supported",
            "getResourceRefs", getType().getName()));
    }    
}
        
