/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.util;
/**
	Use Assert to checkpoint conditions within the code.
 */
public class Assert
{
	/*
		An assertion has failed, do something with the message.
	 */
		static private final void
	throwIt( String msg )
	{
		AssertError	e	= new AssertError( msg );
		// always print it here, so it will be seen
		e.printStackTrace();
		throw e;
	}
	
	/**
		If expression is false, throw an AssertError which
		incorporates the message.
		<p>
		If expression is true, do nothing.
		
		@param assertIsTrue		boolean derived from callers expression.
		@param msg				message to be added to AssertError upon failure	
	 */
		static public final void
	assertit( boolean assertIsTrue, Object msg )
	{
		if ( ! assertIsTrue )
		{
			throwIt( msg.toString() );
		}
	}
	
		static public final void
	assertRange( int value, int min, int max, Object msgIn )
	{
		assertRange( (long)value, (long)min, (long)max, msgIn );
	}
	
	
		static public final void
	assertRange( long value, long min, long max, Object msgIn )
	{
		if ( value < min || value > max )
		{
			String	rangeString	= "[" + min + ", " + max + "]";
			String	msg	= "illegal integer value = " + value +
				" must be in range " + rangeString;
				
			if ( msgIn != null )
			{
				msg	+= " ( " + msgIn + " )";
			}
			
			throwIt( msg );
		}
	}
};


