/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.backend;

import java.util.logging.Level;
import java.io.InputStream;
import java.io.IOException;


/**
 * Workaround for now for the lack of APIs to access wsgen and wsimport utilities
 * @author Jerome Dochez
 */
public class ProcessWatcher {
    
    Process toWatch = null;
    
    /** Creates a new instance of ProcessWatcher */
    public ProcessWatcher(Process p) {
        toWatch = p;
    }
    
    public int watch() {
        InputStream input = toWatch.getInputStream();
        InputStream error = toWatch.getErrorStream();
        boolean notDone = true;
        do {
            try {
                while (input.available()>0) {
                    dump(input);
                }
                while (error.available()>0) {
                    dump(error);
                }
            } catch(IOException e) {
                
            }
            try {
                toWatch.exitValue();
                notDone = false;
            } catch(IllegalThreadStateException e) {
            }            
        } while (notDone);
        return toWatch.exitValue();
    }
    
    public void dump(InputStream is) throws IOException {
        if (is.available()>0) {
            byte[] bytes = new byte[is.available()];
            is.read(bytes, 0, bytes.length);
            System.out.println(new String(bytes));
        }
    }
}
