/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author mu125243
 */
public class FilesCollector implements Collector {
    
    private String repositoryDir ;
    private String reportDir;
    private List<String> files;
    private String dataType;
    private static Logger logger =
            LogDomains.getLogger(LogDomains.ADMIN_LOGGER);
    /** Creates a new instance of FilesCollector */
    public FilesCollector(String repositoryDir, String reportDir, 
            List<String> files, String dataType) {
        this.repositoryDir = repositoryDir;
        this.reportDir = reportDir;
        this.files = files;
        this.dataType = dataType;
    }
    
    public Data capture() throws DiagnosticException {
        WritableDataImpl writableData = null;
        if (files != null && repositoryDir != null && reportDir != null) {
            writableData = new WritableDataImpl(dataType);
            for(String fileName : files) {
                String srcFile = repositoryDir + File.separator + fileName;
                if(new File(srcFile).exists()) {
                    String destFile = reportDir + File.separator + fileName;
                    try {
                        FileUtils.copyFile(srcFile, destFile);
                        writableData.addChild(new FileData(fileName, dataType));
                    } catch(IOException io) {
                        log(Level.WARNING, "Error occurred during copy of file" + srcFile);
                    }
                    
                }
            }
        }
        return writableData;
    }
    
    private void log(Level level, String message) {
        logger.log(level, message);
    }
}
