/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/* 
 * ProcessExecutorException.java
 *
 * Created on June 22, 2002, 9:03 PM
 * 
 * @author  bnevins
 * @version $Revision: 1.2 $
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/diagnostics/collect/ProcessExecutorException.java,v $
 *
 */

package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.util.i18n.StringManager;



/* This Exception should ONLY be created and thrown by ProcessExecutor
 */

 public class ProcessExecutorException extends Exception
{
	ProcessExecutorException(String key, String defalt) 
	{
		super(localStrings.getStringWithDefault(key, defalt));
	}

	ProcessExecutorException(String key, String defalt, Object[] objs) 
	{
		super(localStrings.getStringWithDefault(key, defalt, objs));
	}

	ProcessExecutorException(String key, String defalt, Throwable t) 
	{
		super(localStrings.getStringWithDefault(key, defalt) 
				+ " -- " + t.getMessage(), t);
	}

	ProcessExecutorException(String key, String defalt, Object[] objs, Throwable t) 
	{
		super(localStrings.getStringWithDefault(key, defalt, objs) 
				+ " -- " + t.getMessage(), t);

             
    }
	
	private static final StringManager localStrings = 
				StringManager.getManager(ProcessExecutor.class);

}



