/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.*;
import java.util.*;
import java.lang.reflect.*;
import com.sun.enterprise.util.LocalStringManagerImpl;
// IASRI 4660742 START
import java.util.logging.*;
import com.sun.logging.*;
// IASRI 4660742 END

/**
 *********************************************************************
 *********************************************************************
 *  NOTE : THIS CLASS IS NO LONGER USED.  IT PARSES J2SDKEE 1.2.x
 *        STYLE PROPERTIES, WHICH ARE NOT SUPPORTED IN J2SDKEE 1.3.x.
 *        SEE com.sun.enterprise.repository.J2EEResourceCollection instead
 *********************************************************************
 *********************************************************************
 *
 * This class parses a set of properties value into a Hashtable of
 * DataSource objects. The format of the properties is
 *
 * xadatasource.0.jndiname=<jndi name>
 * xadatasource.0.classname=<class name>
 * xadatasource.0.dbuser=<db user>
 * xadatasource.0.dbpassword=<db password>
 * xadatasource.0.prop.<prop1>=<value 1>
 * xadatasource.0.prop.<prop2>=<value 2>
 *
 * xadatasource.1.jndiname=<jndi name>
 * xadatasource.1.classname=<class name>
 * xadatasource.1.prop.<prop1>=<value 1>
 * xadatasource.1.prop.<prop2>=<value 2>
 * xadatasource.1.dbuser=<db user>
 * xadatasource.1.dbpassword=<db password>
 * 
 * and so on
 *
 *
 * For example,
 * 
 * xadatasource.0.jndiname=bank/AccountDB
 * xadatasource.0.classname=com.oracle.driver.XADataSource
 * xadatasource.0.dbuser=sa
 * xadatasource.0.dbpassword=sa
 * xadatasource.0.prop.host=xyz
 * xadatasource.0.prop.port=123
 *
 */
public class DataSourceParser {

// IASRI 4660742 START
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.ROOT_LOGGER);
        }
// IASRI 4660742 END
    static private final String DS = "xadatasource";
    static private final String JNDINAME = "jndiname";
    static private final String CLASSNAME = "classname";
    static private final String PROP = "prop";
    static private final String DBUSER = "dbuser";
    static private final String DBPASSWORD = "dbpassword";

    static private LocalStringManagerImpl localStrings =
        new LocalStringManagerImpl(DataSourceParser.class);

/*********************************************************************
 *********************************************************************
 *  NOTE : THIS CLASS IS NO LONGER USED.  IT PARSES J2SDKEE 1.2.x
 *         STYLE PROPERTIES, WHICH ARE NOT SUPPORTED IN J2SDKEE 1.3.x.
 *         SEE com.sun.enterprise.repository.J2EEResourceCollection instead
 *********************************************************************
 *********************************************************************/

    private DataSourceParser() {
    }

    /**
     * Parse a property value
     *
     * @param prop The property value
     * 
     * @return Vector DataSourceInfo objects
     *
     * @exception DataSourceParserException Thrown if there is an error
     * in parsing
     */
    public Vector parseProperties(Properties props) {

        Vector list = new Vector();
        int count = 0;
        while (true) {
            String jndiName = 
                props.getProperty(DS + "." + count + "." + JNDINAME);
            String className =
                props.getProperty(DS + "." + count + "." + CLASSNAME);
            String dbUser =
                props.getProperty(DS + "." + count + "." + DBUSER);
            String dbPassword =
                props.getProperty(DS + "." + count + "." + DBPASSWORD);
            if (jndiName == null || className == null) break;
            try {
                DataSourceInfo dsi = new DataSourceInfo();
                dsi.jndiName = jndiName;
                dsi.dbUser = dbUser;
                dsi.dbPassword = dbPassword;
                Object obj = Class.forName(className).newInstance();
                dsi.dataSource = obj;
                list.addElement(dsi);
            } catch (Exception ex) {
                Object[] args = {className};
//IASRI 4660742                System.err.println
//IASRI 4660742                    (localStrings.getLocalString("enterprise.repository.init.class.err", "", args));
//IASRI 4660742                    System.err.println("");
// START OF IASRI 4660742
			_logger.log(Level.SEVERE,"enterprise.repository_init_class_err", args);
// END OF IASRI 4660742
            }
            count++;
        }
        
        // set the properties
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String) e.nextElement();
            String val = props.getProperty(key);
            if (key.startsWith(DS) && key.indexOf(PROP) != -1) {
                try {
                    String s = key.substring(DS.length()+1,
                                             key.indexOf(".",
                                                         DS.length()+1));
                    int idx = Integer.parseInt(s);
                    String prop = key.substring(key.lastIndexOf(PROP + ".") +
                                                PROP.length() + 1);
                    DataSourceInfo dsi = (DataSourceInfo) list.elementAt(idx);
                    Object obj = dsi.dataSource;
                    invokeSetMethod(obj, prop, val);
                } catch (Exception ex) {
                    Object[] args = {key, val};
//IASRI 4660742                    System.err.println
//IASRI 4660742                        (localStrings.getLocalString("enterprise.repository.prop.err", "", args));
//IASRI 4660742                    System.err.println("");
// START OF IASRI 4660742
			_logger.log(Level.SEVERE,"enterprise.repository_prop_err", args);
// END OF IASRI 4660742
                }
            }
        }
        return list;
    }

    private void invokeSetMethod(Object obj, String prop, String value) 
        throws NoSuchMethodException, InvocationTargetException,
        IllegalAccessException
    {
        Class cl = obj.getClass();
        // change first letter to uppercase
        String setMeth = "set" + prop.substring(0,1).toUpperCase() +
            prop.substring(1);

        // try string method
        try {
            Class[] cldef = {String.class};
            Method meth = cl.getMethod(setMeth, cldef);
            Object[] params = {value};
            meth.invoke(obj, params);
            return;
        } catch (NoSuchMethodException ex) {
            // try int method
            Class[] cldef = {Integer.TYPE};
            Method meth = cl.getMethod(setMeth, cldef);
            Object[] params = {Integer.valueOf(value)};
            meth.invoke(obj, params);
            return;
        }
    }

    static public class DataSourceInfo {
        public String jndiName;
        public String dbUser;
        public String dbPassword;
        public Object dataSource;
        
        public DataSourceInfo() {}
    }
}
