/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;

/**
 * Resource info for ExternalJndiResource.
 * IASRI #4626188
 * @author Sridatta Viswanath
 */
public class ExternalJndiResource extends J2EEResourceBase implements Serializable {
    
    private String jndiLookupName_;
    private String resType_;
    private String factoryClass_;
    
    public ExternalJndiResource(String name) {
        super(name);
    }
    
    protected J2EEResource doClone(String name) {
        ExternalJndiResource clone = new ExternalJndiResource(name);
        clone.setJndiLookupName(getJndiLookupName());
        clone.setResType(getResType());
        clone.setFactoryClass(getFactoryClass());
        return clone;
    }
    
    public int getType() {
        return J2EEResource.EXTERNAL_JNDI_RESOURCE;
    }
    
    public String getJndiLookupName() {
        return jndiLookupName_;
    }
    
    public void setJndiLookupName(String jndiLookupName) {
        jndiLookupName_ = jndiLookupName;
    }
    
    public String getResType() {
        return resType_;
    }
    
    public void setResType(String resType) {
        resType_ = resType;
    }
    
    public String getFactoryClass() {
        return factoryClass_;
    }
    
    public void setFactoryClass(String factoryClass) {
        factoryClass_ = factoryClass;
    }
    
    //START OF IASRI 4660565
    public boolean isJMSConnectionFactory() {
        if (resType_ == null) return false;

        return (IASJ2EEResourceFactoryImpl.JMS_QUEUE_CONNECTION_FACTORY.equals(resType_) ||
                IASJ2EEResourceFactoryImpl.JMS_TOPIC_CONNECTION_FACTORY.equals(resType_)); 
    }
    //END OF IASRI 4660565

    public String toString() {
        return "< External Jndi Resource : " + getName() + " , " + getJndiLookupName() + "... >";    
    }
}
