/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.*;
import javax.naming.*;
// IASRI 4660742 START
import java.util.logging.*;
import com.sun.logging.*;
// IASRI 4660742 END

/*
 * @author Harish Prabandham
 */
class Repository {

// IASRI 4660742 START
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.ROOT_LOGGER);
        }
// IASRI 4660742 END
	/**
	 * Finds a value corresponding to a name stored within this
	 * Repository.
	 * @return A string Value corresponding to the name within the 
	 * repository or null if no such value exists.
	 */
    public String find(String name) {
        try {
            String value = (String) ctx.lookup(name);
            // System.out.println(name + " is bound to " + value);
// START OF IASRI 4660742
            // _logger.log(Level.FINE,name + " is bound to " + value);
// END OF IASRI 4660742
            return value;
        } catch (Exception e) {
      //      e.printStackTrace();
// START OF IASRI 4660742
            // _logger.log(Level.SEVERE,"enterprise.findinrepository_exception",e);
// END OF IASRI 4660742
            return null;
        }
    }
    
	/**
	 * Adds a value corresponding to a name within this Repository.
	 * @return A value true indicates that the value was successfully 
	 * added to the repository.
	 */
    public boolean add(String name, String value) {
        try {
            ctx.rebind(name, value);
            // System.out.println("Added " + name + ", " + value);
// START OF IASRI 4660742
	    //if(_logger.isLoggable(Level.FINE))
                 // _logger.log(Level.FINE,"Added " + name + ", " + value);
// END OF IASRI 4660742
            return true;
	} catch (NamingException ne) {
// IASRI 4660742	    ne.printStackTrace();
// START OF IASRI 4660742
             _logger.log(Level.SEVERE,"enterprise.addinrepository_exception",ne);
// END OF IASRI 4660742
            return false;
	}
    }

	public boolean remove(String name){
    try {
        ctx.unbind(name);
        // System.out.println("Added " + name + ", " + value);
// START OF IASRI 4660742
	    //if(_logger.isLoggable(Level.FINE))
                 // _logger.log(Level.FINE,"Added " + name + ", " + value);
// END OF IASRI 4660742
        return true;
	} catch (NamingException ne) {
// IASRI 4660742	    ne.printStackTrace();
// START OF IASRI 4660742
             _logger.log(Level.SEVERE,"enterprise.delinrepository_exception",ne);
// END OF IASRI 4660742
        return false;
	}
	}

	public String[] keys()
	{
		Vector v = new Vector(10);
		Enumeration e = null;
        try {
            e = ctx.listBindings("");
		} catch (NamingException ne) {
// IASRI 4660742	   		 ne.printStackTrace();
// START OF IASRI 4660742
             _logger.log(Level.SEVERE,"enterprise.naming_exception",ne);
// END OF IASRI 4660742
		}

		while((e != null) && e.hasMoreElements())
		{
			Binding b = (Binding) e.nextElement();
			v.add(b.getName());
		}

		String[] keynames = new String[v.size()];
		v.copyInto(keynames);

		return keynames;
	}

	public String getName()
	{
        return RepositoryContext.getRepositoryName(name);
	}
    
    /**
     * Constructor.....
     */
    public Repository(String repositoryName) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", 
                "com.sun.enterprise.repository.RepositoryInitContextFactory");
        env.put("com.sun.enterprise.repository.name", repositoryName);
	name = repositoryName;
	init(env);
    }


    /**
     * Constructor.....
     */
    public Repository(String repositoryName, String repositoryDir) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", 
                "com.sun.enterprise.repository.RepositoryInitContextFactory");
        env.put("com.sun.enterprise.repository.name", repositoryName);
        env.put("com.sun.enterprise.repository.dir", repositoryDir);
	name = repositoryName;
	init(env);
    }


    /**
     * Initializing the context... 
     */
    private void init(Properties env) {
        try {
            ctx = new InitialContext(env);
        } catch (NamingException ne) {
// IASRI 4660742            ne.printStackTrace();
// START OF IASRI 4660742
             _logger.log(Level.SEVERE,"enterprise.naming_exception",ne);
// END OF IASRI 4660742
            ctx = null;
        }
    }

    
    private Context ctx = null;
	private String name = null;
}
