/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.auth.login;

import java.util.*;
import java.io.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.security.TextLoginDialog;
import com.sun.enterprise.security.GUILoginDialog;

/**
 * This is the default callback handler provided by the application
 * client container. The container tries to use the application specified 
 * callback handler (if provided). If there is no callback handler or if
 * the handler cannot be instantiated then this default handler is used.
 */
public class LoginCallbackHandler implements CallbackHandler 
{
    private boolean isGUI;
    private static LocalStringManagerImpl localStrings =
    new LocalStringManagerImpl(LoginCallbackHandler.class);

    public LoginCallbackHandler() {
        this(true);
    }

    public LoginCallbackHandler(boolean gui) {
        isGUI = gui;
    }

    /**
     * This is the callback method called when authentication data is
     * required. It either pops up a dialog box to request authentication
     * data or use text input.
     * @param the callback object instances supported by the login module.
     */
    public void handle(Callback[] callbacks) throws IOException,
					UnsupportedCallbackException
    {
        if(isGUI) {
            String user = localStrings.getLocalString("login.user", "user");
	    GUILoginDialog gd = new GUILoginDialog(user, callbacks);
	} else {
	    TextLoginDialog td = new TextLoginDialog(callbacks);
        }
    }
}

