/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ss.spi;

import com.sun.enterprise.server.PELaunch;
/**
 * This utility class houses methods to get ASSocketServiceFacade
 * @author Sivakumar Thyagarajan, Binod PG
 * @since SJSAS 9.0
 */ 
public class ASSocketFacadeUtils {
    private static ASSocketServiceFacade _instance = null;
    
    public static ASSocketServiceFacade getASSocketService() {
        try {
            if(_instance == null) {
                String proxyClassName = "com.sun.enterprise.server.ss.ASSocketServiceProxy";
                Class socketServiceProxy = null;
                /* If the new classloader hierachy is switched on, use appserver-chain to load
                   the class */
                if(Boolean.getBoolean(PELaunch.USE_NEW_CLASSLOADER_PROPERTY)) {
                    socketServiceProxy = PELaunch.getAppServerChain().loadClass(proxyClassName);
                } else {
                    socketServiceProxy = ASSocketFacadeUtils.class.getClassLoader().loadClass(proxyClassName);
                }
                _instance = (ASSocketServiceFacade)socketServiceProxy.newInstance();
            }
            return _instance;
        } catch (Exception e) {
            RuntimeException rte = new RuntimeException(e.getMessage());
            rte.initCause(e);
            throw rte;
        }
    }
}
