/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * InvocationTrace.java
 *
 * Created on November 22, 2004, 4:35 PM
 */

package com.sun.enterprise.webservice.monitoring;

import java.util.Date;
import java.util.logging.Level;
import java.io.ByteArrayOutputStream;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * An invocation trace contains the timestamp os a particular
 * message invocation, the stringified SOAP request and 
 * response or the SOAP Faults if the invocation resulted in one.
 *
 * @author Jerome Dochez
 */
public class MessageTraceImpl implements MessageTrace {
        
    private Endpoint source;
    private String soapMessage=null;
    private TransportInfo transportInfo=null;
    private int hashcode=0;
    
    
    /** Creates a new instance of InvocationTrace */
    public MessageTraceImpl() {
        
    }
    
    /** 
     * Return the SOAPMessage as a string including the SOAPHeaders or not
     * @param include the soap headers.
     * @return the soap message
     */ 
    public String getMessage(boolean includeHeaders) {

        if (soapMessage!=null) {
            if (includeHeaders) {
                return soapMessage;
            }
        
            StringBuffer sb = new StringBuffer();
            Pattern p = Pattern.compile("<env:Body>.*</env:Body>");
            Matcher m = p.matcher(soapMessage);
            if (m.find()) {
                return soapMessage.substring(m.start(),m.end());
            } else {
                return soapMessage;
            }
        }
        return null;
    }
    
    /**
     * Return the endpoint where this message originated from
     */
    public Endpoint getEndpoint() {
        return source;
    }
    
    public void setMessageContext(com.sun.xml.rpc.spi.runtime.SOAPMessageContext soapMessageCtx) {
        
        hashcode = soapMessageCtx.hashCode();
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();        
        try {
            soapMessageCtx.getMessage().writeTo(baos);       
        } catch(Exception e) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "Cannot log SOAP Message " + e.getMessage());
        }    

        soapMessage = baos.toString();          
    }
    
    public void setMessageContext(com.sun.xml.ws.spi.runtime.SOAPMessageContext soapMessageCtx) {
        
        hashcode = soapMessageCtx.hashCode();
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();        
        try {
            soapMessageCtx.getMessage().writeTo(baos);       
        } catch(Exception e) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "Cannot log SOAP Message " + e.getMessage());
        }    

        soapMessage = baos.toString();          
    }
    
    public String getMessageID() {
        return String.valueOf(hashcode);
    }
    
    public void setEndpoint(Endpoint source) {
        this.source = source;
    }
    
    public TransportInfo getTransportInfo() {
        return transportInfo;
    }
    
    public void setTransportInfo(TransportInfo info) {
        transportInfo = info;
    }
}
