/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jndi.url.corbaname;

import javax.naming.spi.ResolveResult;
import javax.naming.*;
import java.util.Hashtable;
import java.net.MalformedURLException;

import com.sun.jndi.cosnaming.IiopUrl;

/**
 * A corbaname URL context.
 * 
 * @author Rosanna Lee
 */

public class corbanameURLContext
	extends com.sun.jndi.toolkit.url.GenericURLContext {

    corbanameURLContext(Hashtable env) {
	super(env);
    }

    /**
      * Resolves 'name' into a target context with remaining name.
      * It only resolves the hostname/port number. The remaining name
      * contains the rest of the name found in the URL.
      *
      * For example, with a corbaname  URL 
      * "corbaname:iiop://localhost:900#rest/of/name",
      * this method resolves "corbaname:iiop://localhost:900" to the "NameService"
      * context on for the ORB at 'localhost' on port 900, 
      * and returns as the remaining name "rest/of/name".
      */
    protected ResolveResult getRootURLContext(String name, Hashtable env) 
    throws NamingException {
	return corbanameURLContextFactory.getUsingURLIgnoreRest(name, env);
    }

    /**
     * Return the suffix of a corbaname url.
     * prefix parameter is ignored.
     */
    protected Name getURLSuffix(String prefix, String url)
	throws NamingException {
	    // Rewrite to corbaname url
	    url = corbanameURLContextFactory.rewriteUrl(url);
	    try {
		IiopUrl parsedUrl = new IiopUrl(url);
		return parsedUrl.getCosName();
	    } catch (MalformedURLException e) {
		throw new InvalidNameException(e.getMessage());
	    }
    }

    /**
      * Finds the prefix of a corbaname URL.
      * This is all of the non-string name portion of the URL.
      * The string name portion always occurs after the '#'
      * so we just need to look for that.
      */
    protected String getURLPrefix(String url) throws NamingException {
	int start = url.indexOf('#');

	if (start < 0) {
	    return url;	    // No '#', prefix is the entire URL
	}

	return url.substring(0, start);
    }
}
