/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.connector.grizzly;

import java.util.StringTokenizer;
import java.util.logging.Level;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;

public class SelectorThreadConfig{  
    /**
     * System property for the selector timeout value.
     */
    private static final String SELECTOR_TIMEOUT = 
                "com.sun.enterprise.web.connector.grizzly.selector.timeout";

    
    /**
     * The minimum number of threads used when creating a new 
     * <code>Pipeline</code>
     */
    private static final String MIN_THREAD=
               "com.sun.enterprise.web.connector.grizzly.minWorkerThreads";
    
    
    /**
     * Property used to turn on/off NIO blocking mode.
     */
    private final static String NON_BLOCKING_MODE=
                   "com.sun.enterprise.web.connector.grizzly.useNioNonBlocking";

    /**
     * Property used to turn on/off NIO blocking mode.
     */
    private final static String DISPLAY_CONFIGURATION=
                "com.sun.enterprise.web.connector.grizzly.displayConfiguration";


    private final static String MAX_KEEP_ALIVE_REQUEST =
               "com.sun.enterprise.web.connector.grizzly.maxKeepAliveRequests"; 


    /**
     * Is the <code>ByteBuffer</code> used by the <code>ReadTask</code> use
     * direct <code>ByteBuffer</code> or not.
     */
    private final static String DIRECT_BYTE_BUFFER_READ =
               "com.sun.enterprise.web.connector.grizzly.useDirectByteBuffer";    
 
    /**
     * Always attach a <code>ProcessorTask</code> when creating 
     * a <code>ReadTask</code>
     */
    private final static String PIPELINE_CLASS =
               "com.sun.enterprise.web.connector.grizzly.pipelineClass";

    private final static String MAX_SELECTOR_READ_THREAD=
               "com.sun.enterprise.web.connector.grizzly.maxSelectorReadThread"; 
    private final static String HTTP_HEADER_BUFFER_SIZE =
               "com.sun.enterprise.web.connector.grizzly.maxHttpHeaderSize"; 
    
    private final static String BYTE_BUFFER_VIEW =
               "com.sun.enterprise.web.connector.grizzly.useByteBufferView"; 

    private final static String ALGORITHM_CLASS_NAME=
        "com.sun.enterprise.web.connector.grizzly.algorithmClassName";
    
    private final static String MAX_SELECTOR = 
        "com.sun.enterprise.web.connector.grizzly.maxSelectors";
    
    private final static String FACTORY_TIMEOUT = 
        "com.sun.enterprise.web.connector.grizzly.factoryTimeout";
    
    
    private final static String ASYNCH_HANDLER_CLASS =
        "com.sun.enterprise.web.connector.grizzly.asyncHandlerClass";   
    
    private final static String ASYNCH_HANDLER_PORT =
        "com.sun.enterprise.web.connector.grizzly.asyncHandler.ports";     
    // --------------------------------------------------------- Static -----//


   /**
     * Read systems properties and configure the <code>SelectorThread</code>.
     */
    protected static void configureProperties(SelectorThread selectorThread){
        if (System.getProperty(SELECTOR_TIMEOUT) != null){
            try{
                selectorThread.selectorTimeout = 
                      Integer.parseInt(System.getProperty(SELECTOR_TIMEOUT));
            } catch (NumberFormatException ex){
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidSelectorTimeout");
            }
        }

        if (System.getProperty(MIN_THREAD) != null){
            try{
                selectorThread.minWorkerThreads = 
                    Integer.parseInt(System.getProperty(MIN_THREAD));
            } catch (NumberFormatException ex){
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidMinThreads");
            }
        }        
        
        if (System.getProperty(NON_BLOCKING_MODE) != null){
            selectorThread.useNioNonBlocking = 
                Boolean.valueOf(System.getProperty(NON_BLOCKING_MODE))
                                                                .booleanValue();
        }
        
        
        if (System.getProperty(DISPLAY_CONFIGURATION)!= null){
            selectorThread.displayConfiguration = 
                Boolean.valueOf(System.getProperty(DISPLAY_CONFIGURATION))
                                                                .booleanValue();
        }
              
        if ( System.getProperty(ASYNCH_HANDLER_PORT) != null){
            String ports = System.getProperty(ASYNCH_HANDLER_PORT);
            StringTokenizer st = new StringTokenizer(ports,",");
            while(st.hasMoreTokens()){
                
                if ( st.nextToken()
                        .equals(String.valueOf(selectorThread.getPort()))
                        && System.getProperty(ASYNCH_HANDLER_CLASS)!= null){
                    
                    selectorThread.asyncHandler = (AsyncHandler)
                        loadClassAndInstanciate(
                            System.getProperty(ASYNCH_HANDLER_CLASS)); 
                    selectorThread.asyncExecution = true;
                }
            }
        }           
        
        if (System.getProperty(DIRECT_BYTE_BUFFER_READ)!= null){
            selectorThread.useDirectByteBuffer = 
                Boolean.valueOf(
                    System.getProperty(DIRECT_BYTE_BUFFER_READ)).booleanValue();
        }        
       
        if (System.getProperty(MAX_KEEP_ALIVE_REQUEST) != null){
            try{
                selectorThread.maxKeepAliveRequests = 
                  Integer.parseInt(System.getProperty(MAX_KEEP_ALIVE_REQUEST));
            } catch (NumberFormatException ex){
                ;
            }
        }
        
        if (System.getProperty(PIPELINE_CLASS)!= null){
            selectorThread.pipelineClassName = 
                                            System.getProperty(PIPELINE_CLASS);
        }    
                
        if (System.getProperty(ALGORITHM_CLASS_NAME)!= null){
            selectorThread.algorithmClassName = 
                                      System.getProperty(ALGORITHM_CLASS_NAME);
        }   
        
        if (System.getProperty(BYTE_BUFFER_VIEW)!= null){
            selectorThread.useByteBufferView = 
                Boolean.valueOf(
                            System.getProperty(BYTE_BUFFER_VIEW)).booleanValue();
        }    
             
        if (System.getProperty(MAX_SELECTOR_READ_THREAD) != null){
            try{
                selectorThread.selectorReadThreadsCount = 
                  Integer.parseInt(System.getProperty(MAX_SELECTOR_READ_THREAD));
            } catch (NumberFormatException ex){
                ;
            }
        }
        
        if (System.getProperty(MAX_SELECTOR) != null){
            try{
                SelectorFactory.maxSelectors = 
                  Integer.parseInt(System.getProperty(MAX_SELECTOR));
            } catch (NumberFormatException ex){
                ;
            }
        }

        if (System.getProperty(FACTORY_TIMEOUT) != null){
            try{
                SelectorFactory.timeout = 
                  Integer.parseInt(System.getProperty(FACTORY_TIMEOUT));
            } catch (NumberFormatException ex){
                ;
            }
        }
        
        if (System.getProperty("com.sun.enterprise.web.SubjectDoAs") != null){
            org.apache.catalina.security.SecurityUtil.executeUnderSubjectDoAs = 
                Boolean.valueOf(System.getProperty("com.sun.enterprise.web.SubjectDoAs"))
                                                                .booleanValue();
        }           
    }

    
    /**
     * Configure properties on <code>SelectorThread</code>
     */
    public static void configure(SelectorThread selectorThread){
        configureProperties(selectorThread);
    }

    
    private static Object loadClassAndInstanciate(String className){
         try{
            Class clazz = Class.forName(className);
            return clazz.newInstance();
        } catch (Throwable ex){
            SelectorThread.logger().log(Level.SEVERE,ex.getMessage()
                + ":" + className, ex);          
        }
        return null;   
        
    }

}
