

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.jasper;

/**
 * Base class for all exceptions generated by the JSP engine. Makes it
 * convienient to catch just this at the top-level. 
 *
 * @author Anil K. Vijendran
 */
public class JasperException extends javax.servlet.ServletException {
    
    public JasperException(String reason) {
	super(reason);
    }

    /**
     * Creates a JasperException with the embedded exception and the reason for
     * throwing a JasperException
     */
    public JasperException (String reason, Throwable exception) {
   	super(reason, exception);
    }

    /**
     * Creates a JasperException with the embedded exception
     */
    public JasperException (Throwable exception) {
   	super(exception);
    }
}
